package net.luohuasheng.bee.rest.admin.client.enums;

import org.springframework.util.StringUtils;


/**
 * Description: 文档方法
 *
 * @author panda
 * @version 2015年11月25日 | 0.0.1
 */
public enum DocMethod {
    /**
     * 数据库文档下载
     */
    DB_OUT_DOCX("dbOutDocx", "数据库文档下载"),
    /**
     * 数据库文档显示
     */
    DB_OUT_HTML("dbOutHtml", "数据库文档显示"),
    /**
     * swagger文档下载
     */
    SWAGGER_OUT_DOCX("swaggerOutDocx", "swagger文档下载"),
    /**
     * swagger文档显示
     */
    SWAGGER_OUT_HTML("swaggerOutHtml", "swagger文档显示"),
    ;


    private String code;

    private String description;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private DocMethod(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static DocMethod getTypeByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (DocMethod element : DocMethod.values()) {
            if (element.getCode().equals(code)) {
                return element;
            }
        }
        return null;
    }

}
