package net.luohuasheng.bee.rest.admin.client.enums;

import org.springframework.util.StringUtils;


/**
 * Description: 应用方法
 *
 * @author panda
 * @version 2015年11月25日 | 0.0.1
 */
public enum ApplicationMethod {
    /**
     * 所有状态统计
     */
    STATUS("status", "所有状态统计"),
    /**
     * 请求数前五的状态统计
     */
    TOP_FIVE_STATUS("topFiveStatus", "请求数前五的状态统计"),
    /**
     * 时长统计
     */
    TIMES("times", "时长统计"),
    /**
     * 请求平均时长前五的时长统计
     */
    TOP_FIVE_TIMES("topFiveTimes", "请求平均时长前五的时长统计"),
    /**
     * 响应情况统计
     */
    RESPONSE_LIST("responseList", "响应情况统计"),
    /**
     * 方法监控
     */
    METHODS("methods", "方法监控"),
    /**
     * 调用情况明细
     */
    METHOD_TIMES("methodTimes", "调用情况明细"),
    ;


    private String code;

    private String description;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private ApplicationMethod(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static ApplicationMethod getTypeByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (ApplicationMethod element : ApplicationMethod.values()) {
            if (element.getCode().equals(code)) {
                return element;
            }
        }
        return null;
    }

}
