package net.luohuasheng.bee.rest.admin.client.endpoint;

import net.luohuasheng.bee.rest.admin.client.config.ClientProperties;
import net.luohuasheng.bee.rest.admin.client.dto.system.ActuatorRsetPwdDto;
import net.luohuasheng.bee.rest.admin.client.dto.system.ActuatorUserDto;
import net.luohuasheng.bee.rest.admin.client.interceptor.AdminSecurityFilter;
import net.luohuasheng.bee.rest.admin.client.utils.RequestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 内存监控
 *
 * @author panda
 * @date 2019-06-24
 */
@Component
@RestControllerEndpoint(id = "system")
public class SystemEndPoint {

    private final ClientProperties clientProperties;

    private static final String UNKNOWN = "unknown";

    private final AdminSecurityFilter adminSecurityFilter;

    public SystemEndPoint(ClientProperties clientProperties, AdminSecurityFilter adminSecurityFilter) {
        this.clientProperties = clientProperties;
        this.adminSecurityFilter = adminSecurityFilter;
    }


    @GetMapping("logout")
    public Object logout(HttpServletResponse response) {
        adminSecurityFilter.remove();
        return RequestUtils.ok(response);
    }

    @PostMapping("rsetPwd")
    public Object rsetPwd(@RequestBody ActuatorRsetPwdDto actuatorRsetPwdDto, HttpServletRequest request, HttpServletResponse response) {
        Boolean isConsole = (Boolean) request.getAttribute("isConsole");
        if (!BooleanUtils.isTrue(isConsole) && !clientProperties.getUsername().equals(actuatorRsetPwdDto.getPwdOld())) {
            return securityException("错误的密码", response);
        } else if (StringUtils.isEmpty(actuatorRsetPwdDto.getPwdNew())) {
            return securityException("新密码不能为空", response);
        } else {
            clientProperties.setUsername(actuatorRsetPwdDto.getUserName());
            clientProperties.setPassword(actuatorRsetPwdDto.getPwdNew());
        }
        return RequestUtils.ok(response);
    }

    @RequestMapping(value = "login", method = {RequestMethod.GET, RequestMethod.POST})
    public Object login(@RequestParam String userName, @RequestParam String password, HttpServletResponse response) {
        if (StringUtils.isEmpty(userName) || StringUtils.isEmpty(password)) {
            return securityException("用户信息不能为空", response);
        } else if (!clientProperties.getUsername().equals(userName) || !clientProperties.getPassword().equals(password)) {
            return securityException("错误的用户名或密码", response);
        }
        ActuatorUserDto actuatorUserDto = new ActuatorUserDto();
        actuatorUserDto.setUserName(userName);
        actuatorUserDto.setLastLoginTime(new Date());
        adminSecurityFilter.add(actuatorUserDto);
        return RequestUtils.ok(response);
    }

    private Map<String, String> securityException(String message, HttpServletResponse response) {
        response.setContentType(MediaType.APPLICATION_JSON_VALUE);
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        Map<String, String> map = new HashMap<>(1);
        map.put("message", message);
        return map;
    }


    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");

        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

}
