package net.luohuasheng.bee.rest.admin.client.endpoint;

import net.luohuasheng.bee.rest.admin.client.config.ClientProperties;
import net.luohuasheng.bee.rest.admin.client.utils.NetworkUtils;
import net.luohuasheng.bee.rest.admin.client.utils.RSA;
import net.luohuasheng.bee.rest.admin.client.utils.RequestUtils;
import net.luohuasheng.bee.rest.admin.client.utils.id.IdUtil;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * 内存监控
 *
 * @author panda
 * @date 2019-06-24
 */
@Component
@RestControllerEndpoint(id = "sign")
public class SignEndPoint {

    private final ClientProperties clientProperties;
    private final Long id;

    public SignEndPoint(ClientProperties clientProperties) {
        this.id = IdUtil.getId();
        this.clientProperties = clientProperties;
    }

    @GetMapping("/sign")
    public Map<String, Object> sign(HttpServletRequest request) {
        String ip = NetworkUtils.getIpAddr(request);
        Map<String, Object> map = new HashMap<>(0);
        map.put("version", clientProperties.getSignVersion());
        map.put("id", id);
        map.put("value", RSA.base64Encode(RSA.encryptByPublicKey(ip.getBytes(), clientProperties.getSignKey())));
        return map;
    }

    @GetMapping("/edit")
    public Map<?, ?> edit(@RequestParam Integer version, @RequestParam String publicKey, HttpServletResponse response) {
        clientProperties.setSignKey(publicKey);
        clientProperties.setSignVersion(version);
        return RequestUtils.ok(response);

    }

    @PostMapping("/edit")
    public Object edit2(Integer version, String publicKey, HttpServletResponse response) {
        return edit(version, publicKey, response);
    }

    @GetMapping("/verify")
    public boolean verify(@RequestParam String consoleToken, HttpServletRequest request) {
        String ip = NetworkUtils.getIpAddr(request);
        return RSA.verify(ip + "_" + (System.currentTimeMillis() / 3600000), consoleToken, clientProperties.getSignKey(), StandardCharsets.UTF_8.name());

    }
}
