package net.luohuasheng.bee.rest.admin.client.endpoint;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.Status;
import net.luohuasheng.bee.rest.admin.client.dto.log.FileDto;
import net.luohuasheng.bee.rest.admin.client.dto.log.FileReadDto;
import net.luohuasheng.bee.rest.admin.client.dto.log.LoggerDto;
import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 内存监控
 *
 * @author panda
 * @date 2019-06-24
 */
@Component
@RestControllerEndpoint(id = "logback")
public class LogbackEndPoint {

    private static final String ROOT = "root";
    private static final Integer BIT = 1024;

    @Value("${LOG_HOME:-.}")
    private String logHome;

    private String managerDir;


    @Value("${management.logback.maxSize:100}")
    private Integer maxSize = 100;

    @Autowired(required = false)
    private HttpServletResponse response;

    @PostConstruct
    public void init() {
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
        managerDir = "";
        for (Status status : loggerContext.getStatusManager().getCopyOfStatusList()) {
            if (status.getOrigin() instanceof TimeBasedRollingPolicy) {
                TimeBasedRollingPolicy<?> policy = (TimeBasedRollingPolicy<?>) status.getOrigin();
                if (policy.getActiveFileName().contains("/")) {
                    managerDir = policy.getActiveFileName().substring(0, policy.getActiveFileName().lastIndexOf("/"));
                }
            }
        }
    }

    @GetMapping("/")
    public List<LoggerDto> call() {
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
        List<LoggerDto> loggerDtos = new ArrayList<>();
        List<Logger> loggers = loggerContext.getLoggerList();
        for (Logger logger : loggers) {
            loggerDtos.add(conventLogger(logger));
        }
        return loggerDtos;
    }


    @PostMapping("/{level}")
    public String level(@PathVariable("level") String level, @RequestParam String packages) {
        try {
            packages = URLDecoder.decode(packages, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();

        List<Logger> loggers = loggerContext.getLoggerList();
        for (Logger logger : loggers) {
            if (ROOT.equalsIgnoreCase(packages) || logger.getName().startsWith(packages)) {
                logger.setLevel(Level.toLevel(level));
            }
        }
        if (ROOT.equalsIgnoreCase(packages)) {
            return "{'message':'全局日志级别修改为[" + level + "]}'";
        } else {
            return "'message':'包名[" + packages + "]日志级别修改为[" + level + "]'";
        }
    }

    @PostMapping("/filter")
    public List<LoggerDto> filter(@RequestParam Integer packageLevel, @RequestParam String packages) {
        if (packageLevel == 0) {
            packageLevel = 999;
        }
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
        List<Logger> loggers = loggerContext.getLoggerList();

        List<LoggerDto> loggerDtos = new ArrayList<>();
        for (Logger logger : loggers) {
            boolean isOk = (StringUtils.isEmpty(packages) || logger.getName().equals(packages) || (logger.getName().startsWith(packages)) && logger.getName().split("\\.").length < packageLevel + 1);
            if (isOk) {
                loggerDtos.add(conventLogger(logger));
            }
        }
        return loggerDtos;
    }

    @PostMapping("/loadFile")
    public FileReadDto loadFile(@RequestParam String dir, @RequestParam String fileName, @RequestParam Long fileId, @RequestParam(required = false, defaultValue = "0") Long range) {
        File file = getFile(dir, fileName);
        try {
            FileReadDto fileReadDto = new FileReadDto();
            fileReadDto.setFileId(fileId);
            fileReadDto.setSize(file.length());
            StringBuffer sb = new StringBuffer();
            FileReader reader = new FileReader(file);
            BufferedReader br = new BufferedReader(reader);
            br.skip(range);
            String str = null;
            Integer bytesRead = 0;
            while ((str = br.readLine()) != null) {
                bytesRead += (str.getBytes().length + 1);
                if (bytesRead > maxSize * 1024) {
                    break;
                }
                sb.append(str).append("\r\n");
            }
            fileReadDto.setText(sb.toString());
            if (sb.length() == 0) {
                fileReadDto.setRange((file.length()));
            } else {
                fileReadDto.setRange(range + bytesRead);
            }
            br.close();
            reader.close();
            return fileReadDto;
        } catch (IOException e) {
            return null;
        }
    }

    @PostMapping("/tailFile")

    public FileReadDto tailFile(@RequestParam String dir, @RequestParam String fileName, @RequestParam Long fileId,@RequestParam(required = false, defaultValue = "0") Long range) {
        if (range == 0) {
            File file = getFile(dir, fileName);
            try {
                FileReader reader = new FileReader(file);
                BufferedReader br = new BufferedReader(reader);
                FileReadDto fileReadDto = new FileReadDto();
                fileReadDto.setFileId(fileId);
                fileReadDto.setSize(file.length());
                fileReadDto.setRange(file.length());
                StringBuffer sb = new StringBuffer();
                if (file.length() > maxSize * BIT) {
                    br.skip(file.length() - maxSize * BIT);
                }
                String str = null;
                br.readLine();
                while ((str = br.readLine()) != null) {
                    sb.append(str).append("\r\n");
                }
                fileReadDto.setText(sb.toString());
                br.close();
                reader.close();
                return fileReadDto;
            } catch (IOException e) {
                return null;
            }
        } else {
            return loadFile(dir, fileName, fileId, range);
        }

    }


    @GetMapping("/downloadFile")
    public void downloadFile(@RequestParam String dir, @RequestParam String fileName) {

        File file = getFile(dir, fileName);
        if (file.length() > 0) {
            try {
                response.setContentLength((int) file.length());
                response.setHeader("content-type", "application/octet-stream");
                response.setHeader("content-disposition", "attachment;filename*=utf-8''" + URLEncoder.encode(fileName, "UTF-8"));
                StreamUtils.copy(new FileInputStream(file), response.getOutputStream());
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @PostMapping("/list")
    private List<FileDto> list(@RequestParam String dir) {
        List<FileDto> fileDtos = new ArrayList<>();
        if (!StringUtils.isEmpty(managerDir)) {
            dir = managerDir + dir;
        } else {
            dir = logHome.replace("-.", ".") + "/logs" + dir;
        }
        File file = new File(dir);
        if (file.exists()) {
            for (File listFile : file.listFiles()) {
                if (listFile.canRead() && !listFile.isHidden()) {
                    FileDto fileDto = new FileDto();
                    fileDto.setDirectory(listFile.isDirectory());
                    fileDto.setFileName(listFile.getName());
                    fileDto.setLastModified(listFile.lastModified());
                    fileDto.setLength(listFile.length());
                    if (listFile.isFile()) {
                        fileDto.setFileType(listFile.getName().substring(listFile.getName().lastIndexOf(".") + 1));
                    } else {
                        fileDto.setFileType("");
                    }
                    fileDtos.add(fileDto);
                }
            }
        }
        fileDtos.sort((o2, o1) -> o1.getLastModified().compareTo(o2.getLastModified()));
        return fileDtos;
    }


    @GetMapping("/getCssFile")
    public Set<String> getCssFile() {
        Set<String> baseanmeSet = new HashSet<>();
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = pathMatchingResourcePatternResolver.getResources("classpath:page/static/styles/*.css");
            for (int i = 0; i < resources.length; i++) {
                Resource resource = resources[i];
                String filePath = resource.getFilename();
                baseanmeSet.add(filePath.substring(0, filePath.indexOf(".")));
            }
        } catch (IOException ignored) {
        }
        return baseanmeSet;

    }

    private File getFile(String dir, String fileName) {
        if (!StringUtils.isEmpty(managerDir)) {
            dir = managerDir + dir;
        } else {
            dir = logHome.replace("-.", ".") + "/logs" + dir;
        }
        File file = new File(dir + fileName);
        return file;
    }

    private LoggerDto conventLogger(Logger logger) {
        LoggerDto loggerDto = new LoggerDto();
        loggerDto.setName(logger.getName());
        if (logger.getLevel() != null) {
            loggerDto.setLevel(logger.getLevel().levelStr);
        } else {
            loggerDto.setLevel(getParentLevel(logger).levelStr);
        }
        return loggerDto;
    }

    private Level getParentLevel(Logger logger) {
        Logger parent = (Logger) FieldUtils.getFieldValue("parent", logger);
        Level level = parent.getLevel();
        if (level == null) {
            return getParentLevel(parent);
        } else {
            return level;
        }

    }
}
