package net.luohuasheng.bee.rest.admin.client.endpoint;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 应用监控
 *
 * @author panda
 * @date 2019-06-24
 */
@Component
@RestControllerEndpoint(id = "env2")
public class EnvEndPoint {
    @Autowired
    private StandardEnvironment environment;


    @RequestMapping(method = RequestMethod.GET, //
            value = "/info")
    public Object info() {
        Set<String> keys = new TreeSet<>();
        for (PropertySource<?> propertySource : environment.getPropertySources()) {
            if ("java.class.path".equals(propertySource.getName())) {
                continue;
            }
            if (propertySource.getSource() instanceof Map) {
                keys.addAll(((Map<String, ?>) propertySource.getSource()).keySet());
            } else if (propertySource.getSource() instanceof Properties) {
                Properties properties = (Properties) propertySource.getSource();
                keys.addAll(properties.stringPropertyNames());
            }
        }

        return loadInfo(keys);

    }

    @RequestMapping(method = RequestMethod.GET, //
            value = "/info/{name:.*}")

    public Object info2(@PathVariable String name) {
        Set<String> keys = new TreeSet<>();
        for (PropertySource<?> propertySource : environment.getPropertySources()) {
            if ("java.class.path".equals(propertySource.getName())) {
                continue;
            }
            if (propertySource.getSource() instanceof Map) {
                keys.addAll(((Map<String, ?>) propertySource.getSource()).keySet().stream().filter(key -> key.contains(name)).collect(Collectors.toList()));
            } else if (propertySource.getSource() instanceof Properties) {
                Properties properties = (Properties) propertySource.getSource();
                keys.addAll(properties.stringPropertyNames().stream().filter(key -> key.contains(name)).collect(Collectors.toList()));
            }
        }
        return loadInfo(keys);
    }

    private Map<String, Object> loadInfo(Set<String> keys) {
        Map<String, Object> objectMap = new TreeMap<>();
        for (String key : keys) {
            if (!key.contains(".") || key.contains("class.path") || key.endsWith(".jar")) {
                continue;
            }
            Object value = environment.getProperty(key);
            if (key.toLowerCase().contains("key") || key.toLowerCase().contains("password") || key.toLowerCase().contains("pwd")) {
                value = "******";
            }
            System.out.println(key);
            String[] names = key.split("\\.");

            Map<String, Object> map = null;
            for (int i = 0; i < names.length; i++) {
                String name = names[i];
                if (map == null) {
                    map = (Map<String, Object>) objectMap.get(name);
                    if (map == null) {
                        map = new HashMap<>();
                        objectMap.put(name, map);
                    }
                } else {
                    if (i == names.length - 1) {
                        map.put(name, value);
                    } else {
                        Object map2 = map.computeIfAbsent(name, k -> new HashMap<>());
                        if (map2 instanceof Map) {
                            map = (Map<String, Object>) map2;
                        }

                    }
                }
            }
        }
        return objectMap;
    }

}
