package net.luohuasheng.bee.rest.admin.client.endpoint;

import net.luohuasheng.bee.rest.admin.client.components.DataSourceComponent;
import net.luohuasheng.bee.rest.admin.client.utils.Db2Word;
import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.GetMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.*;
import java.util.concurrent.ExecutionException;

/**
 * 内存监控
 *
 * @author panda
 * @date 2019-06-24
 */
@Component
@RestControllerEndpoint(id = "doc")
public class DocEndPoint {
//
//    @Autowired
//    private SwaggerService swaggerService;


    @Autowired(required = false)
    private HttpServletResponse response;
    @Autowired
    private HttpServletRequest request;

    @Autowired(required = false)
    private DataSourceComponent dataSourceComponent;

    @Autowired
    private ApplicationContext applicationContext;


//    @GetMapping("/swaggerOutDocx")
//    private Object swaggerOutDocx() throws IOException {
//
//        response.setHeader("Content-Disposition", "attachment; filename=\"swagger.docx\"");
//        response.setContentType("application/octet-stream;charset=UTF-8");
//        Swagger swagger = swaggerService.getSwagger(request);
//
//        String fileName = swagger.getInfo().getTitle();
//        if (request.getHeader("User-Agent").toLowerCase().indexOf("firefox") > 0) {
//            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), "ISO8859-1");
//            // firefox浏览器
//        } else if (request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0) {
//            fileName = URLEncoder.encode(fileName, "UTF-8");
//            // IE浏览器
//        } else if (request.getHeader("User-Agent").toUpperCase().indexOf("CHROME") > 0) {
//            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), "ISO8859-1");
//            // 谷歌
//        }
//        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + ".docx\"");
//
//        Swagger2Word.exportDoc(swagger, loadMessage(), response.getOutputStream());
//        return null;
//    }
//
//    @GetMapping("/swaggerOutHtml")
//
//    public Object swaggerOutHtml() throws IOException {
//        Swagger2Word.exportHtml(swaggerService.getSwagger(request), loadMessage(), response.getOutputStream());
//        return null;
//    }

    @GetMapping("/dbOutDocx")

    public Object dbOutDocx() throws IOException, SQLException, ExecutionException, InterruptedException {

        response.setHeader("Content-Disposition", "attachment; filename=\"db.docx\"");
        response.setContentType("application/octet-stream;charset=UTF-8");
        Db2Word.exportDoc(dataSourceComponent == null ? Collections.emptyList() : dataSourceComponent.getTables(), response.getOutputStream());
        return null;
    }

    @GetMapping("/dbOutHtml")

    public Object dbOutHtml() throws IOException, SQLException, ExecutionException, InterruptedException {

        Db2Word.exportHtml(dataSourceComponent == null ? Collections.emptyList() : dataSourceComponent.getTables(), response.getOutputStream());

        return null;
    }


    private Map<String, String> loadMessage() {
        Map<String, String> value = new TreeMap<>();
        Map<String, MessageSource> messageSources = applicationContext.getBeansOfType(MessageSource.class);
        for (MessageSource messageSource : messageSources.values()) {
            if (messageSource instanceof ResourceBundleMessageSource) {
                for (String basename : ((ResourceBundleMessageSource) messageSource).getBasenameSet()) {
                    try {
                        Method method = ReflectionUtils.findMethod(ResourceBundleMessageSource.class, "getResourceBundle", String.class, Locale.class);
                        method.setAccessible(true);
                        ResourceBundle resourceBundle = (ResourceBundle) method.invoke(messageSource, basename, LocaleContextHolder.getLocale());
                        method.setAccessible(false);
                        for (String key : resourceBundle.keySet()) {
                            value.put(key, resourceBundle.getString(key));
                        }
                    } catch (Exception ignored) {
                    }
                }
            } else if (messageSource instanceof ReloadableResourceBundleMessageSource) {
                try {
                    Method method = ReflectionUtils.findMethod(ReloadableResourceBundleMessageSource.class, "getMergedProperties", Locale.class);
                    method.setAccessible(true);
                    Object object = method.invoke(messageSource, LocaleContextHolder.getLocale());
                    method.setAccessible(false);
                    Properties properties = (Properties) FieldUtils.getFieldValue(object, "properties");
                    if (properties != null) {
                        for (String key : properties.stringPropertyNames()) {
                            value.put(key, properties.getProperty(key));
                        }
                    }
                } catch (Exception ignored) {
                }

            }
        }

        return value;

    }


}
