//package net.luohuasheng.bee.rest.admin.client.endpoint;
//
//
//import net.luohuasheng.bee.rest.admin.client.components.DataSourceComponent;
//import net.luohuasheng.bee.rest.admin.client.components.RedisComponent;
//import net.luohuasheng.bee.rest.admin.client.dto.db.*;
//import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
//import org.apache.commons.pool2.impl.GenericObjectPool;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
//import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
//import org.springframework.stereotype.Component;
//import org.springframework.util.CollectionUtils;
//import org.springframework.util.NumberUtils;
//import org.springframework.util.StringUtils;
//import org.springframework.web.bind.annotation.GetMapping;
//import org.springframework.web.bind.annotation.RequestParam;
//import redis.clients.jedis.Jedis;
//import redis.clients.jedis.JedisPool;
//
//import javax.sql.DataSource;
//import java.io.IOException;
//import java.util.*;
//
///**
// * 内存监控
// *
// * @author panda
// * @date 2019-06-24
// */
//@Component
//@RestControllerEndpoint(id = "db")
//public class DbEndPoint {
//    private final Logger logger = LoggerFactory.getLogger(this.getClass());
//
//
//    @Autowired(required = false)
//    private RedisComponent redisComponent;
//
//    @Autowired(required = false)
//    private DataSourceComponent dataSourceComponent;
//
//
//    @GetMapping("/dbList")
//    public Object dbList() throws IOException {
//
//        List<DbInfo> dbInfos = new ArrayList<>();
//        if (dataSourceComponent != null) {
//            dbInfos.addAll(dataSourceComponent.dbInfos());
//        }
//        if (redisComponent != null) {
//            dbInfos.addAll(redisComponent.dbInfos());
//        }
//
//        return dbInfos;
//    }
//
//    @GetMapping("/dbDetailList")
//    public Object dbDetailList() throws IOException {
//
//        List<Object> list = new ArrayList<>();
//        for (int i = 0; !CollectionUtils.isEmpty(dataSourceComponent.getDataSources()) && i < dataSourceComponent.getDataSources().size(); i++) {
//            list.add(dataSourceComponent.getHikariStatData(i));
//        }
//        for (int i = 0; redisComponent != null && !CollectionUtils.isEmpty(redisComponent.getRedisConnectionFactories()) && i < (redisComponent.getRedisConnectionFactories().size()); i++) {
//            RedisConnectDto redisConnectDto = new RedisConnectDto();
//            JedisConnectionFactory dataSource = redisComponent.getRedisConnectionFactories().get(i);
//            redisConnectDto.setHostName(dataSource.getHostName() + ":" + dataSource.getPort() + ":" + dataSource.getDatabase());
//            redisConnectDto.setMinIdle(dataSource.getPoolConfig().getMinIdle());
//            redisConnectDto.setMaxIdle(dataSource.getPoolConfig().getMaxIdle());
//            redisConnectDto.setMaxTotal(dataSource.getPoolConfig().getMaxTotal());
//            redisConnectDto.setName("Redis-" + dataSource.hashCode());
//            try {
//                JedisPool pool = (JedisPool) FieldUtils.getFieldValue(dataSource, "pool");
//                redisConnectDto.setNumActive(pool.getNumActive());
//                redisConnectDto.setNumIdle(pool.getNumIdle());
//                redisConnectDto.setNumWaiters(pool.getNumWaiters());
//                GenericObjectPool genericObjectPool = (GenericObjectPool) FieldUtils.getFieldValue(pool, "internalPool");
//                redisConnectDto.setBorrowedCount(genericObjectPool.getBorrowedCount());
//                redisConnectDto.setMeanActiveTimeMillis(genericObjectPool.getMeanActiveTimeMillis());
//                redisConnectDto.setMeanBorrowWaitTimeMillis(genericObjectPool.getMeanBorrowWaitTimeMillis());
//
//            } catch (Exception e) {
//                logger.error(e.getMessage());
//            }
//
//            list.add(redisConnectDto);
//        }
//        return list;
//    }
//
//    @GetMapping("/processList")
//    public Object processList(@RequestParam String dbIndex) {
//
//        String[] dbIndexs = dbIndex.split("_");
//
//        MonitorDbType monitorDbType = MonitorDbType.type(dbIndexs[0]);
//
//        if (monitorDbType != null) {
//            String processListSql = monitorDbType.getProcessSql();
//            DataSource dataSource = dataSourceComponent.getDataSources().get(Integer.parseInt(dbIndexs[1]));
//            QueryRunner queryRunner = new QueryRunner(dataSource);
//            try {
//                return queryRunner.query(processListSql, new BeanListHandler<>(monitorDbType.getProcessClass()));
//            } catch (Exception e) {
//                return Collections.EMPTY_LIST;
//            }
//        } else if ("redis".equals(dbIndexs[0])) {
//            List<Map<String, Object>> list = new ArrayList<>();
//            JedisConnectionFactory jedisConnectionFactory = redisComponent.getRedisConnectionFactories().get(Integer.parseInt(dbIndexs[1]));
//            JedisPool jedisPool = (JedisPool) FieldUtils.getFieldValue(jedisConnectionFactory, "pool");
//            Jedis jedis = null;
//            try {
//                jedis = jedisPool.getResource();
//                String clientStr = jedis.clientList();
//                String[] clientList = clientStr.split("\n");
//                for (String client : clientList) {
//                    Map<String, Object> map = new HashMap<>();
//                    String[] clients = client.split(" ");
//                    for (String value : clients) {
//                        String[] values = value.split("=");
//                        if (values.length == 2) {
//
//                            map.put(values[0], org.apache.commons.lang3.StringUtils.isNumeric(values[1]) ? NumberUtils.parseNumber(values[1], Long.class) : values[1]);
//                        }
//                    }
//                    list.add(map);
//
//                }
//
//
//            } catch (Exception e) {
//                logger.error(e.getMessage());
//
//            } finally {
//                if (jedis != null) {
//                    jedis.close();
//                }
//            }
//            return list;
//        }
//
//        return Collections.EMPTY_LIST;
//    }
//
//    @GetMapping("/variablesList")
//    public Object variablesList(@RequestParam String dbIndex) {
//
//        String[] dbIndexs = dbIndex.split("_");
//
//        MonitorDbType monitorDbType = MonitorDbType.type(dbIndexs[0]);
//
//        if (monitorDbType != null) {
//
//            String processListSql = monitorDbType.getVariablesSql();
//            if (StringUtils.isEmpty(processListSql)) {
//                return Collections.EMPTY_LIST;
//            } else {
//                DataSource dataSource = dataSourceComponent.getDataSources().get(Integer.parseInt(dbIndexs[1]));
//                QueryRunner queryRunner = new QueryRunner(dataSource);
//                List<Object> list = new ArrayList<>();
//                try {
//                    if (monitorDbType.equals(MonitorDbType.DM)) {
//                        List<Map<String, Object>> maps = queryRunner.query("select  * from SYS.V$SYSTEMINFO", new MapListHandler());
//                        for (Map map : maps) {
//                            for (Object key : map.keySet()) {
//                                Map<String, Object> value = Maps.newHashMap();
//                                value.put("name", key);
//                                value.put("value", map.get(key));
//                                list.add(value);
//                            }
//                        }
//
//                    }
//
//                    if (!StringUtils.isEmpty(monitorDbType.getVariablesSql())) {
//                        list.addAll(queryRunner.query(monitorDbType.getVariablesSql(), new BeanListHandler<>(Variables.class)));
//                    }
//                    if (!StringUtils.isEmpty(monitorDbType.getStatusSql())) {
//                        list.addAll(queryRunner.query(monitorDbType.getStatusSql(), new BeanListHandler<>(Status.class)));
//                    }
//                } catch (Exception e) {
//                    logger.error(e.getMessage());
//
//                }
//                return list;
//            }
//        } else if ("redis".equals(dbIndexs[0])) {
//            List<Map<String, Object>> list = new ArrayList<>();
//            JedisConnectionFactory jedisConnectionFactory = redisComponent.getRedisConnectionFactories().get(Integer.parseInt(dbIndexs[1]));
//            JedisPool jedisPool = (JedisPool) FieldUtils.getFieldValue(jedisConnectionFactory, "pool");
//            Jedis jedis = null;
//            try {
//                jedis = jedisPool.getResource();
//                String info = jedis.info("all");
//                String[] infoList = info.split("\n");
//                for (String infos : infoList) {
//                    String[] values = infos.split(":");
//                    if (values.length == 2) {
//                        Map<String, Object> map = new HashMap<>(0);
//                        map.put("name", values[0]);
//                        values[1] = values[1].replace("\r", "");
//                        map.put("value", org.apache.commons.lang3.StringUtils.isNumeric(values[1]) ? NumberUtils.parseNumber(values[1], Long.class) : values[1]);
//                        list.add(map);
//                    }
//                }
//
//
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                if (jedis != null) {
//                    jedis.close();
//                }
//            }
//            return list;
//        }
//
//        return Collections.EMPTY_LIST;
//    }
//
//
//}
