package net.luohuasheng.bee.rest.admin.client.endpoint;

import io.micrometer.core.instrument.LocalMeterRegistry;
import net.luohuasheng.bee.rest.admin.client.aop.DynamicAdvice;
import net.luohuasheng.bee.rest.admin.client.aop.DynamicPointcut;
import net.luohuasheng.bee.rest.admin.client.dto.application.*;
import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

import static net.luohuasheng.bee.rest.admin.client.utils.ConstantUtils.METHOD_MONITOR_CLASSS;
import static net.luohuasheng.bee.rest.admin.client.utils.ConstantUtils.MONITOR_CLASSS;

/**
 * 应用监控
 *
 * @author panda
 * @date 2019-06-24
 */
@Component
@RestControllerEndpoint(id = "application")
public class ApplicationEndPoint {
    private final static Map<String, MonitorMethodTimeDto> LOGIN_CACHE_MAP = new HashMap<>();
    private static final Set<String> REGISTRY_URIS = new TreeSet<>();

    private final static Integer EXPIRE = 600;
    private final static String CACHE_POOL_KEY = "cache-schedule-pool-%d";
    private final static ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1,
            new BasicThreadFactory.Builder().namingPattern(CACHE_POOL_KEY).daemon(true).build());

    static {
        executorService.scheduleAtFixedRate(() -> {
            Set<String> expiredKeys = new HashSet<>();
            for (Map.Entry<String, MonitorMethodTimeDto> stringActuatorUserDtoEntry : LOGIN_CACHE_MAP.entrySet()) {
                if (stringActuatorUserDtoEntry.getValue().getLastTime().before(DateUtils.addSeconds(new Date(), -EXPIRE))) {
                    expiredKeys.add(stringActuatorUserDtoEntry.getKey());
                }
            }
            for (String expiredKey : expiredKeys) {
                LOGIN_CACHE_MAP.remove(expiredKey);
            }

        }, 0, 1, TimeUnit.MINUTES);
    }

    @Autowired
    private LocalMeterRegistry localMeterRegistry;

    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DynamicPointcut dynamicPointcut;
    private boolean isInit = false;

    public void init() {
        List<ServletRegistrationBean> servletRegistrationBeans = new ArrayList<>(applicationContext.getBeansOfType(ServletRegistrationBean.class).values());
        List<RequestMappingHandlerMapping> requestMappingHandlerMappings = new ArrayList<>(applicationContext.getBeansOfType(RequestMappingHandlerMapping.class).values());
        for (RequestMappingHandlerMapping requestMappingHandlerMapping : requestMappingHandlerMappings) {
            for (Map.Entry<RequestMappingInfo, HandlerMethod> requestMappingInfoHandlerMethodEntry : requestMappingHandlerMapping.getHandlerMethods().entrySet()) {
                Method method = requestMappingInfoHandlerMethodEntry.getValue().getMethod();

                if (dynamicPointcut.checkRequestPackages(method.getDeclaringClass())) {
                    MONITOR_CLASSS.add(method.getDeclaringClass().getCanonicalName() + "." + method.getName());
                }
                REGISTRY_URIS.addAll(requestMappingInfoHandlerMethodEntry.getKey().getPatternsCondition().getPatterns());
            }
        }
        for (ServletRegistrationBean servletRegistrationBean : servletRegistrationBeans) {
            REGISTRY_URIS.addAll(servletRegistrationBean.getUrlMappings());
        }
        isInit = true;
    }


    @PostMapping("/methodClassName/{classPath}")
    public Object methodClassName(@PathVariable("classPath") String classPath, @RequestParam String classMethods, @RequestParam String classMethod) {


        if (!StringUtils.isEmpty(classMethod)) {
            LOGIN_CACHE_MAP.remove(classMethod);
        }
        if (!StringUtils.isEmpty(classMethods)) {
            for (String className : classMethods.split(",")) {
                MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(className);
                if (monitorMethodTimeDto == null) {
                    monitorMethodTimeDto = new MonitorMethodTimeDto();
                    monitorMethodTimeDto.setFullClassName(className);
                    monitorMethodTimeDto.setLastTime(new Date());
                    LOGIN_CACHE_MAP.put(className, monitorMethodTimeDto);
                }
            }
        }

        return "ok";
    }

    @GetMapping("/methodClassNameDetail/{classMethod}")
    public List<ResponseMethodTimeDto> methodClassNameDetail(@PathVariable("classMethod") String classMethod) {

        MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(classMethod);
        if (monitorMethodTimeDto == null) {
            return new ArrayList<>();
        }
        List<ResponseMethodTimeDto> responseMethodTimeDtos = new ArrayList<>();
        List<List<MethodTimeDto>> all = new ArrayList<>(monitorMethodTimeDto.getQueue().getAll());
        for (List<MethodTimeDto> methodTimeDtos : all) {
            ResponseMethodTimeDto responseMethodTimeDto = new ResponseMethodTimeDto();
            responseMethodTimeDto.setClassName(methodTimeDtos.get(0).getClassZ().getCanonicalName());
            responseMethodTimeDto.setMethodName(methodTimeDtos.get(0).getMethod().getName());
            responseMethodTimeDto.setLevelType(methodTimeDtos.get(0).getLevel());
            responseMethodTimeDto.setRequestTime((new Date(methodTimeDtos.get(0).getTimestamp())));
            responseMethodTimeDto.setTime(methodTimeDtos.get(methodTimeDtos.size() - 1).getTimestamp() - methodTimeDtos.get(0).getTimestamp());
            responseMethodTimeDto.setType(methodTimeDtos.get(methodTimeDtos.size() - 1).getCallType());
            if (methodTimeDtos.size() > 2) {
                buildChildResponseMethodTime(methodTimeDtos.subList(1, methodTimeDtos.size() - 1), responseMethodTimeDto);
            }
            responseMethodTimeDtos.add(responseMethodTimeDto);
        }
        return responseMethodTimeDtos;
    }

    private void buildChildResponseMethodTime(List<MethodTimeDto> methodTimeDtos, ResponseMethodTimeDto responseMethodTimeDto) {
        Method firstMethod = null;
        int firstIndex = 0;
        for (int i = 0; i < methodTimeDtos.size(); i++) {
            MethodTimeDto methodTimeDto = methodTimeDtos.get(i);
            if (firstMethod == null) {
                firstIndex = i;
                firstMethod = methodTimeDto.getMethod();
            } else if (firstMethod.equals(methodTimeDto.getMethod())) {
                firstMethod = null;
                ResponseMethodTimeDto responseMethodTimeChildDto = new ResponseMethodTimeDto();
                responseMethodTimeChildDto.setClassName(methodTimeDtos.get(firstIndex).getClassZ().getCanonicalName());
                responseMethodTimeChildDto.setMethodName(methodTimeDtos.get(firstIndex).getMethod().getName());
                responseMethodTimeChildDto.setRequestTime(new Date(methodTimeDtos.get(firstIndex).getTimestamp()));
                responseMethodTimeChildDto.setTime(methodTimeDtos.get(i).getTimestamp() - methodTimeDtos.get(firstIndex).getTimestamp());
                responseMethodTimeChildDto.setLevelType(methodTimeDtos.get(firstIndex).getLevel());
                responseMethodTimeChildDto.setType(methodTimeDtos.get(i).getCallType());
                if (methodTimeDtos.size() > 2) {
                    buildChildResponseMethodTime(methodTimeDtos.subList(firstIndex + 1, i), responseMethodTimeChildDto);
                }
                responseMethodTimeDto.getChildren().add(responseMethodTimeChildDto);

            }
        }

    }

    @GetMapping("/topFiveTimes")
    public List<ResponseTimeDto> topFiveTimes() {
        Map<String, ResponseTimeDto> responseTimeDtoMap = localMeterRegistry.getTimeMap();
        List<ResponseTimeDto> result = new ArrayList<>(responseTimeDtoMap.values());
        result.sort((o1, o2) -> Double.compare(o2.getTime(), o1.getTime()));
        return result.subList(0, Math.min(result.size(), 5));
    }

    @GetMapping("/times")
    public ResponseTimeDto times() {
        Map<String, ResponseTimeDto> responseTimeDtoMap = localMeterRegistry.getTimeMap();
        ResponseTimeDto result = new ResponseTimeDto();
        for (ResponseTimeDto value : responseTimeDtoMap.values()) {
            result.getLessTwoHundred().addAndGet(value.getLessTwoHundred().get());
            result.getLessFiveHundred().addAndGet(value.getLessFiveHundred().get());
            result.getLessOneThousand().addAndGet(value.getLessOneThousand().get());
            result.getGreaterOneThousand().addAndGet(value.getGreaterOneThousand().get());
            result.getAll().addAndGet(value.getAll().get());
        }
        return result;
    }

    @RequestMapping(method = {RequestMethod.GET, RequestMethod.POST},
            value = "/method/{className:.*}")
    @ResponseBody
    public Object methodClassName(@PathVariable String className) {

        MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(className);
        if (monitorMethodTimeDto == null) {
            return new ArrayList<>();
        }
        List<ResponseMethodTimeDto> responseMethodTimeDtos = new ArrayList<>();
        List<List<MethodTimeDto>> all = new ArrayList<>(monitorMethodTimeDto.getQueue().getAll());
        for (List<MethodTimeDto> methodTimeDtos : all) {
            ResponseMethodTimeDto responseMethodTimeDto = new ResponseMethodTimeDto();
            responseMethodTimeDto.setClassName(methodTimeDtos.get(0).getClassZ().getCanonicalName());
            responseMethodTimeDto.setMethodName(methodTimeDtos.get(0).getMethod().getName());
            responseMethodTimeDto.setLevelType(methodTimeDtos.get(0).getLevel());
            responseMethodTimeDto.setRequestTime(new Date(methodTimeDtos.get(0).getTimestamp()));
            responseMethodTimeDto.setTime(methodTimeDtos.get(methodTimeDtos.size() - 1).getTimestamp() - methodTimeDtos.get(0).getTimestamp());
            responseMethodTimeDto.setType(methodTimeDtos.get(methodTimeDtos.size() - 1).getCallType());
            if (methodTimeDtos.size() > 2) {
                buildChildResponseMethodTime(methodTimeDtos.subList(1, methodTimeDtos.size() - 1), responseMethodTimeDto);
            }
            responseMethodTimeDtos.add(responseMethodTimeDto);
        }
        return responseMethodTimeDtos;
    }

    @GetMapping("/status")
    public Map<String, Long> status() {
        Map<String, Long> map = new HashMap<>();
        for (Map.Entry<String, ResponseStatusDto> statusDtoEntry : localMeterRegistry.getStatusMap().entrySet()) {
            ResponseStatusDto statusDto = statusDtoEntry.getValue();
            for (int i = 1; i < 6; i++) {
                String key = i + "xx";
                Long count = map.get(key);
                if (count == null) {
                    map.put(key, ((AtomicLong) Objects.requireNonNull(FieldUtils.getFieldValue("s" + i, statusDto))).longValue());
                } else {
                    map.put(key, count + ((AtomicLong) Objects.requireNonNull(FieldUtils.getFieldValue("s" + i, statusDto))).longValue());
                }
            }

        }
        return map;
    }

    @GetMapping("/topFiveStatus")
    public List<ResponseStatusDto> topFiveStatus() {
        List<ResponseStatusDto> responseStatusDtos = new ArrayList<>(localMeterRegistry.getStatusMap().values());
        responseStatusDtos.sort((o1, o2) -> (int) (o2.getAll().get() - o1.getAll().get()));
        return responseStatusDtos.size() > 5 ? responseStatusDtos.subList(0, 5) : responseStatusDtos;

    }

    @GetMapping("/responseList")
    public List<Map<String, Object>> responseList() {
        Map<String, ResponseTimeDto> responseTimeDtoMap = localMeterRegistry.getTimeMap();
        List<Map<String, Object>> result = new ArrayList<>();
        List<ResponseStatusDto> responseStatusDtos = new ArrayList<>(localMeterRegistry.getStatusMap().values());
        for (ResponseTimeDto responseTimeDto : responseTimeDtoMap.values()) {
            for (ResponseStatusDto responseStatusDto : responseStatusDtos) {
                if (responseTimeDto.getUri().equals(responseStatusDto.getUri())) {
                    Map<String, Object> map = new HashMap<>(0);
                    result.add(map);
                    map.put("uri", responseTimeDto.getUri());
                    map.put("responseStatusDto", responseStatusDto);
                    map.put("responseTimeDto", responseTimeDto);
                }
            }

        }
        return result;
    }

    @GetMapping("/methods")
    public Object methods(@RequestParam String searchValue) {
        if (!isInit) {
            init();
        }
        Map<String, Map<String, Boolean>> mapMap = new TreeMap<>();
        for (String method : MONITOR_CLASSS) {
            if (!StringUtils.isEmpty(searchValue) && !method.contains(searchValue.trim())) {
                continue;
            }
            int index = method.lastIndexOf(".");
            String className = method.substring(0, index);
            String methodName = method.substring(index + 1);
            Map<String, Boolean> map = mapMap.computeIfAbsent(className, k -> new TreeMap<>());
            map.put(methodName, false);
            MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(method);
            if (monitorMethodTimeDto != null) {
                map.put(methodName, true);

            }

        }
        return mapMap;
    }

    @RequestMapping(method = {RequestMethod.GET, RequestMethod.POST},
            value = "/method/classNames")
    public Object methodClassName(@RequestBody List<String> classNames, @RequestParam(required = false) String classMethod) {

        if (!StringUtils.isEmpty(classMethod)) {
            LOGIN_CACHE_MAP.remove(classMethod);
        }
        if (!CollectionUtils.isEmpty(classNames)) {
            for (String className : classNames) {
                MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(className);
                if (monitorMethodTimeDto == null) {
                    monitorMethodTimeDto = new MonitorMethodTimeDto();
                    monitorMethodTimeDto.setFullClassName(className);
                    monitorMethodTimeDto.setLastTime(new Date());
                    LOGIN_CACHE_MAP.put(className, monitorMethodTimeDto);
                }
            }
        }

        return "ok";
    }

    @GetMapping("/methodTimes")
    public List<MethodMonitorTimeDto> methodTimes(@RequestParam String searchValue, @RequestParam DynamicAdvice.LevelType selectValue) {

        List<MethodMonitorTimeDto> methodMonitorTimeDtos = new ArrayList<>();
        for (Map.Entry<String, MethodMonitorTimeDto> stringMethodMonitorTimeDtoEntry : METHOD_MONITOR_CLASSS.entrySet()) {
            boolean isOk = (selectValue == null || stringMethodMonitorTimeDtoEntry.getValue().getLevelType().equals(selectValue)) && (searchValue == null || stringMethodMonitorTimeDtoEntry.getKey().contains(searchValue));
            if (isOk) {
                methodMonitorTimeDtos.add(stringMethodMonitorTimeDtoEntry.getValue());
            }
        }
        return methodMonitorTimeDtos;
    }

    public MonitorMethodTimeDto getMonitorMethodTimeDto(String classFullName) {
        return LOGIN_CACHE_MAP.get(classFullName);

    }
}
