package net.luohuasheng.bee.rest.admin.client.endpoint;

import net.luohuasheng.bee.rest.admin.client.aop.DynamicAdvice;
import net.luohuasheng.bee.rest.admin.client.dto.api.ApiCount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.lang.reflect.Method;
import java.util.*;

/**
 * 应用监控
 *
 * @author panda
 * @date 2019-06-24
 */
@Component
@RestControllerEndpoint(id = "api")
public class ApiEndPoint {
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    @Autowired
    private DynamicAdvice dynamicAdvice;

    @GetMapping("/")
    public List<ApiCount> api() {
        List<ApiCount> apis = new ArrayList<>();
        for (Map.Entry<RequestMappingInfo, HandlerMethod> requestMappingInfoHandlerMethodEntry : requestMappingHandlerMapping.getHandlerMethods().entrySet()) {
            Set<String> urls = new HashSet<>();
            for (String pattern : requestMappingInfoHandlerMethodEntry.getKey().getPatternsCondition().getPatterns()) {
                for (RequestMethod method : requestMappingInfoHandlerMethodEntry.getKey().getMethodsCondition().getMethods()) {
                    urls.add(pattern + "_" + method.name());
                }
            }
            Method method = requestMappingInfoHandlerMethodEntry.getValue().getMethod();
            ApiCount apiCount = dynamicAdvice.getApiCount(method);
            if (apiCount != null) {
                apiCount.setRestApi(String.join(",", urls));
                apis.add(apiCount);
            }
        }
        return apis;
    }


}
