package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.SimpleInfoContributor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.*;

/**
 * @author wusuoming
 */
public class VersionDto {


    private static final VersionDto INSTANCE = load();
    private static final List<InfoContributor> INFO_CONTRIBUTORS = loadInfoEndpoints();

    private String buildGroupId;
    private String buildArtifactId;
    private String buildOsName;
    private String buildTime;
    private String buildName;
    private String buildEnvironment;
    private String buildVersion;
    private String springBootVersion;


    public static VersionDto getInstance() {
        return INSTANCE;
    }

    public static List<InfoContributor> getInfoContributors() {
        return INFO_CONTRIBUTORS;
    }

    private static VersionDto load() {
        VersionDto version = new VersionDto();
        Properties properties = loadProperties();
        version.setBuildTime(properties.getProperty("git.build.time"));
        version.setBuildEnvironment(properties.getProperty("Build-Jdk"));
        version.setBuildName(properties.getProperty("git.build.user.name"));
        version.setBuildVersion(properties.getProperty("git.build.version"));
        version.setBuildGroupId(properties.getProperty("groupId"));
        version.setBuildArtifactId(properties.getProperty("artifactId"));
        version.setSpringBootVersion(properties.getProperty("Spring-Boot-Version"));
        version.setBuildOsName(properties.getProperty("buildOsName"));
        return version;
    }

    private static List<InfoContributor> loadInfoEndpoints() {
        Properties properties = loadProperties();
        List<InfoContributor> infoEndpoints = new ArrayList<>();
        for (Object key : properties.keySet()) {
            Object value = properties.getProperty((String) key);
            infoEndpoints.add(new SimpleInfoContributor((String) key, value));
        }
        return infoEndpoints;
    }


    private static Properties loadProperties() {
        Properties properties = new Properties();
        try {
            Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            loadValue(en, properties);
            en = Thread.currentThread().getContextClassLoader().getResources("git.properties");
            loadValue(en, properties);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }


    private static void loadValue(Enumeration<URL> en, Properties properties) throws IOException {
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            if (url.getPath().contains("BOOT-INF/lib")) {
                continue;
            }
            if (url.getPath().contains(Objects.requireNonNull(VersionDto.class.getClassLoader().getResource("")).getFile().split("!")[0])) {
                InputStream is = url.openStream();
                properties.load(is);
            }


        }
    }


    public String getBuildName() {
        return buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getBuildEnvironment() {
        return buildEnvironment;
    }

    public void setBuildEnvironment(String buildEnvironment) {
        this.buildEnvironment = buildEnvironment;
    }

    public String getBuildVersion() {
        return buildVersion;
    }

    public void setBuildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
    }


    public String getBuildTime() {
        return buildTime;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    public String getBuildGroupId() {
        return buildGroupId;
    }

    public void setBuildGroupId(String buildGroupId) {
        this.buildGroupId = buildGroupId;
    }

    public String getBuildArtifactId() {
        return buildArtifactId;
    }

    public void setBuildArtifactId(String buildArtifactId) {
        this.buildArtifactId = buildArtifactId;
    }

    public String getSpringBootVersion() {
        return springBootVersion;
    }

    public void setSpringBootVersion(String springBootVersion) {
        this.springBootVersion = springBootVersion;
    }

    public String getBuildOsName() {
        return buildOsName;
    }

    public void setBuildOsName(String buildOsName) {
        this.buildOsName = buildOsName;
    }
}
