package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import oshi.hardware.CentralProcessor;

/**
 * 处理器信息
 *
 * @author panda
 * @date 2018-12-30
 */
public class ProcessorDto {

    /**
     * 启动时间
     */
    private long uptime;
    /**
     * 处理器名称
     */
    private String cpuName;
    /**
     * 处理器序列号
     */
    private String processorId;
    /**
     * 是否64位
     */
    private Boolean isCpu64;


    /**
     * 核心数
     */
    private Integer physicalCount;

    /**
     * 处理器数目
     */
    private double processorCount;

    /**
     * 线程数
     */
    private Integer logicalCount;


    public long getUptime() {
        return uptime;
    }

    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    public String getCpuName() {
        return cpuName;
    }

    public void setCpuName(String cpuName) {
        this.cpuName = cpuName;
    }

    public String getProcessorId() {
        return processorId;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
    }

    public Boolean getCpu64() {
        return isCpu64;
    }

    public void setCpu64(Boolean cpu64) {
        isCpu64 = cpu64;
    }

    public ProcessorDto() {
        CentralProcessor cpu = SystemInfoUtils.getProcessor();
        cpuName = cpu.getProcessorIdentifier().getName();
        processorId = cpu.getProcessorIdentifier().getProcessorID();
        isCpu64 = cpu.getProcessorIdentifier().isCpu64bit();
        uptime = cpu.getProcessorIdentifier().getVendorFreq();
        physicalCount = cpu.getPhysicalProcessorCount();
        logicalCount = cpu.getLogicalProcessorCount();
    }


    public Integer getPhysicalCount() {
        return physicalCount;
    }

    public void setPhysicalCount(Integer physicalCount) {
        this.physicalCount = physicalCount;
    }

    public Integer getLogicalCount() {
        return logicalCount;
    }

    public void setLogicalCount(Integer logicalCount) {
        this.logicalCount = logicalCount;
    }


    public double getProcessorCount() {
        return processorCount;
    }

    public void setProcessorCount(double processorCount) {
        this.processorCount = processorCount;
    }
}
