package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

import java.util.*;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 进程信息
 *
 * @author panda
 * @date 2019-01-01
 */
public class ProcessDto {
    private static Map<Integer, ProcessDto> processeMap = new HashMap<>();
    private String name;


    private Integer pid;
    private Integer parentPid;
    private String user;
    private String group;
    private OSProcess.State state;
    private Integer threadCount;
    /**
     * 虚拟内存
     */
    private Long virtualSize;
    /**
     * 物理内存
     */
    private Long residentSetSize;
    private Double memPercent;
    private Double cpuPercent;

    private Long startTime;
    private Long currentTime;
    private Long bytesRead;
    private Long bytesWritten;
    private Long openFiles;
    private String path;
    private String commandLine;
    private String currentWorkingDirectory;
    /**
     * 读取流量速度
     */
    private Long readSpeed = 0L;
    /**
     * 写入流量速度
     */
    private Long writeSpeed = 0L;


    private static final String PROCESSE_STORE_POOL_KEY = "processe-schedule-pool-%d";

    static {
        ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1,
                new BasicThreadFactory.Builder().namingPattern(PROCESSE_STORE_POOL_KEY).daemon(true).build());
        executorService.scheduleAtFixedRate(() -> {
            Map<Integer, ProcessDto> processeMapTmp = new HashMap<>();
            List<ProcessDto> processDtos = loadProcesseDtos();
            for (ProcessDto processDto : processDtos) {
                ProcessDto processDto1 = processeMap.get(processDto.pid);
                processeMapTmp.put(processDto.pid, processDto);
                if (processDto1 != null) {
                    processDto.readSpeed = processDto.bytesRead - processDto1.bytesRead;
                    processDto.writeSpeed = processDto.bytesWritten - processDto1.bytesWritten;
                    processDto.cpuPercent = (processDto.currentTime - processDto1.currentTime) / 1000d / SystemInfoUtils.getProcessor().getLogicalProcessorCount();
                }
            }
            processeMap = processeMapTmp;
        }, 0, 1, TimeUnit.SECONDS);
    }

    private static List<ProcessDto> loadProcesseDtos() {
        List<ProcessDto> processDtos = new ArrayList<>();
        long totalMemory = SystemInfoUtils.getMemory().getTotal();
        for (OSProcess process : SystemInfoUtils.getProcesses()) {
            ProcessDto processDto = new ProcessDto();
            processDto.commandLine = process.getCommandLine();
            processDto.currentWorkingDirectory = process.getCurrentWorkingDirectory();
            processDto.parentPid = process.getParentProcessID();
            processDto.pid = process.getProcessID();
            processDto.threadCount = process.getThreadCount();
            processDto.bytesRead = process.getBytesRead();
            processDto.bytesWritten = process.getBytesWritten();
            processDto.user = process.getUser();
            processDto.group = process.getGroup();
            processDto.state = process.getState();
            processDto.virtualSize = process.getVirtualSize();
            processDto.residentSetSize = process.getResidentSetSize();
            processDto.startTime = process.getStartTime();
            processDto.openFiles = process.getOpenFiles();
            processDto.name = process.getName();
            processDto.memPercent = 1.0 * (process.getResidentSetSize()) / totalMemory;
            processDto.currentTime = process.getKernelTime() + process.getUserTime();
            processDto.path = process.getPath();
            processDtos.add(processDto);
        }

        return processDtos;
    }

    public static ProcessDto getProcesseDto(String pid) {
        return processeMap.get(Integer.parseInt(pid));
    }

    private static Comparator<ProcessDto> loadComparator(OperatingSystem.ProcessSort processSort) {
        return (o1, o2) -> {
            switch (processSort) {
                case CPU:
                    if (o1.cpuPercent == null || o2.cpuPercent == null) {
                        return 0;
                    } else {
                        return o2.cpuPercent.compareTo(o1.cpuPercent);
                    }
                case PID:
                    return o2.pid.compareTo(o1.pid);
                case NAME:
                    return o2.name.compareTo(o1.name);
                case MEMORY:
                    return o2.residentSetSize.compareTo(o1.residentSetSize);
                case NEWEST:
                    return o1.startTime.compareTo(o2.startTime);
                case OLDEST:
                    return o2.startTime.compareTo(o1.startTime);
                case PARENTPID:
                    return o2.parentPid.compareTo(o1.parentPid);
                default:
                    return o2.memPercent.compareTo(o1.memPercent);
            }
        };
    }

    public static List<ProcessDto> createProcesseDto(OperatingSystem.ProcessSort processSort) {
        List<ProcessDto> processDtos = new ArrayList<>();
        for (Map.Entry<Integer, ProcessDto> stringDiskStoreDtoEntry : processeMap.entrySet()) {
            processDtos.add(stringDiskStoreDtoEntry.getValue());
        }
        processDtos.sort(loadComparator(processSort));
        return processDtos;
    }

    public static List<ProcessDto> createProcesseDto(OperatingSystem.ProcessSort processSort, Integer limit) {
        List<ProcessDto> processDtos = createProcesseDto(processSort);
        List<ProcessDto> processDtos2 = new ArrayList<>();
        for (Integer i = 0; i < limit && i < processDtos.size(); i++) {
            processDtos2.add(processDtos.get(i));
        }
        return processDtos2;
    }

    public Integer getPid() {
        return pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public Integer getParentPid() {
        return parentPid;
    }

    public void setParentPid(Integer parentPid) {
        this.parentPid = parentPid;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }


    public Integer getThreadCount() {
        return threadCount;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public Long getVirtualSize() {
        return virtualSize;
    }

    public void setVirtualSize(Long virtualSize) {
        this.virtualSize = virtualSize;
    }

    public Long getResidentSetSize() {
        return residentSetSize;
    }

    public void setResidentSetSize(Long residentSetSize) {
        this.residentSetSize = residentSetSize;
    }


    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getBytesRead() {
        return bytesRead;
    }

    public void setBytesRead(Long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public Long getBytesWritten() {
        return bytesWritten;
    }

    public void setBytesWritten(Long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public Long getOpenFiles() {
        return openFiles;
    }

    public void setOpenFiles(Long openFiles) {
        this.openFiles = openFiles;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getCommandLine() {
        return commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public String getCurrentWorkingDirectory() {
        return currentWorkingDirectory;
    }

    public void setCurrentWorkingDirectory(String currentWorkingDirectory) {
        this.currentWorkingDirectory = currentWorkingDirectory;
    }

    public OSProcess.State getState() {
        return state;
    }

    public void setState(OSProcess.State state) {
        this.state = state;
    }


    public Double getCpuPercent() {
        return cpuPercent;
    }

    public void setCpuPercent(Double cpuPercent) {
        this.cpuPercent = cpuPercent;
    }

    public Long getReadSpeed() {
        return readSpeed;
    }

    public void setReadSpeed(Long readSpeed) {
        this.readSpeed = readSpeed;
    }

    public Long getWriteSpeed() {
        return writeSpeed;
    }

    public void setWriteSpeed(Long writeSpeed) {
        this.writeSpeed = writeSpeed;
    }

    public Double getMemPercent() {
        return memPercent;
    }

    public void setMemPercent(Double memPercent) {
        this.memPercent = memPercent;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCurrentTime() {
        return currentTime;
    }

    public void setCurrentTime(Long currentTime) {
        this.currentTime = currentTime;
    }
}
