package net.luohuasheng.bee.rest.admin.client.dto.monitor;


import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import oshi.hardware.NetworkIF;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 网络信息
 *
 * @author panda
 * @date 2019-01-01
 */
public class NetworkDto {

    private static Map<String, NetworkDto> netDtoMap = new HashMap<>();

    /**
     * 网络名
     */
    private String name;
    /**
     * IPV4地址
     */
    private String ipv4addr;

    /**
     * 接收到的字节数
     */
    private Long bytesRecv;
    /**
     * 返回给客户端的字节数
     */
    private Long bytesSent;
    /**
     * 接收到的包数
     */
    private Long packetsRecv;
    /**
     * 返回给客户端的包数
     */
    private Long packetsSent;


    /**
     * 下行网速
     */
    private Long rxSpeed = 0L;
    /**
     * 上行网速
     */
    private Long txSpeed = 0L;
    /**
     * 上行包流量
     */
    private Long rxbSpeed = 0L;
    /**
     * 下行包流量
     */
    private Long txbSpeed = 0L;

    static {
        ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1,
                new BasicThreadFactory.Builder().namingPattern("net-schedule-pool-%d").daemon(true).build());
        executorService.scheduleAtFixedRate(() -> {
            Map<String, NetworkDto> netDtoMapTmp = new HashMap<>();
            List<NetworkDto> netDtos = loadNetDto();
            for (NetworkDto netDto : netDtos) {
                NetworkDto netDto1 = netDtoMap.get(netDto.getName());
                netDtoMapTmp.put(netDto.getName(), netDto);
                if (netDto1 != null) {
                    netDto.rxSpeed = netDto.bytesRecv - netDto1.bytesRecv;
                    netDto.txSpeed = netDto.bytesSent - netDto1.bytesSent;
                    netDto.rxbSpeed = netDto.packetsRecv - netDto1.packetsRecv;
                    netDto.txbSpeed = netDto.packetsSent - netDto1.packetsSent;
                }
            }
            netDtoMap = netDtoMapTmp;
        }, 0, 1, TimeUnit.SECONDS);
    }

    private static List<NetworkDto> loadNetDto() {
        List<NetworkDto> netDtos = new ArrayList<>();

        for (NetworkIF networkIF : SystemInfoUtils.getNetworkIFs()) {
            NetworkDto netDto = new NetworkDto();
            String[] ipv4addrs = networkIF.getIPv4addr();
            if (!ArrayUtils.isEmpty(ipv4addrs)) {
                netDto.ipv4addr = ipv4addrs[0];
                netDto.name = networkIF.getName();
                netDto.bytesRecv = networkIF.getBytesRecv();
                netDto.bytesSent = networkIF.getBytesSent();
                netDto.packetsRecv = networkIF.getPacketsRecv();
                netDto.packetsSent = networkIF.getPacketsSent();
                netDtos.add(netDto);
            }
        }
        return netDtos;
    }

    public static List<NetworkDto> createNetDtos() {
        List<NetworkDto> netDtos = new ArrayList<>();
        for (Map.Entry<String, NetworkDto> stringNetworkDtoEntry : netDtoMap.entrySet()) {
            netDtos.add(stringNetworkDtoEntry.getValue());
        }
        return netDtos;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIpv4addr() {
        return ipv4addr;
    }

    public void setIpv4addr(String ipv4addr) {
        this.ipv4addr = ipv4addr;
    }

    public Long getBytesRecv() {
        return bytesRecv;
    }

    public void setBytesRecv(Long bytesRecv) {
        this.bytesRecv = bytesRecv;
    }

    public Long getBytesSent() {
        return bytesSent;
    }

    public void setBytesSent(Long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public Long getPacketsRecv() {
        return packetsRecv;
    }

    public void setPacketsRecv(Long packetsRecv) {
        this.packetsRecv = packetsRecv;
    }

    public Long getPacketsSent() {
        return packetsSent;
    }

    public void setPacketsSent(Long packetsSent) {
        this.packetsSent = packetsSent;
    }

    public Long getRxSpeed() {
        return rxSpeed;
    }

    public void setRxSpeed(Long rxSpeed) {
        this.rxSpeed = rxSpeed;
    }

    public Long getTxSpeed() {
        return txSpeed;
    }

    public void setTxSpeed(Long txSpeed) {
        this.txSpeed = txSpeed;
    }

    public Long getRxbSpeed() {
        return rxbSpeed;
    }

    public void setRxbSpeed(Long rxbSpeed) {
        this.rxbSpeed = rxbSpeed;
    }

    public Long getTxbSpeed() {
        return txbSpeed;
    }

    public void setTxbSpeed(Long txbSpeed) {
        this.txbSpeed = txbSpeed;
    }
}
