package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import oshi.hardware.GlobalMemory;

/**
 * 内存信息
 *
 * @author panda
 * @date 2018-12-30
 */
public class MemoryDto {
    /**
     * 总内存
     */
    private long total;
    /**
     * 活跃内存
     */
    private long available;
    /**
     * 虚拟内存大小
     */
    private long swapTotal;
    /**
     * 已使用虚拟内存
     */
    private long swapUsed;
    /**
     * 内存写入虚拟内存大小
     */
    private long swapPagesIn;
    /**
     * 虚拟内存写入内存大小
     */
    private long swapPagesOut;
    /**
     * 缓冲区大小
     */
    private long pageSize;

    public MemoryDto() {
        GlobalMemory memory = SystemInfoUtils.getMemory();
        total = memory.getTotal();
        available = memory.getAvailable();
        swapTotal = memory.getVirtualMemory().getSwapTotal();
        swapUsed = memory.getVirtualMemory().getSwapUsed();
        swapPagesIn = memory.getVirtualMemory().getSwapPagesIn();
        swapPagesOut = memory.getVirtualMemory().getSwapPagesOut();
        pageSize = memory.getPageSize();
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getAvailable() {
        return available;
    }

    public void setAvailable(long available) {
        this.available = available;
    }

    public long getSwapTotal() {
        return swapTotal;
    }

    public void setSwapTotal(long swapTotal) {
        this.swapTotal = swapTotal;
    }

    public long getSwapUsed() {
        return swapUsed;
    }

    public void setSwapUsed(long swapUsed) {
        this.swapUsed = swapUsed;
    }

    public long getSwapPagesIn() {
        return swapPagesIn;
    }

    public void setSwapPagesIn(long swapPagesIn) {
        this.swapPagesIn = swapPagesIn;
    }

    public long getSwapPagesOut() {
        return swapPagesOut;
    }

    public void setSwapPagesOut(long swapPagesOut) {
        this.swapPagesOut = swapPagesOut;
    }

    public long getPageSize() {
        return pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }
}
