package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;

import java.util.ArrayList;
import java.util.List;

/**
 * 文件分区属性
 *
 * @author panda
 * @date 2019-01-01
 */
public class FileSystemDto {
    private String name;
    private String mount;
    private String volume;
    private Long totalSpace;
    private Long usableSpace;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMount() {
        return mount;
    }

    public void setMount(String mount) {
        this.mount = mount;
    }

    public String getVolume() {
        return volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public Long getTotalSpace() {
        return totalSpace;
    }

    public void setTotalSpace(Long totalSpace) {
        this.totalSpace = totalSpace;
    }

    public Long getUsableSpace() {
        return usableSpace;
    }

    public void setUsableSpace(Long usableSpace) {
        this.usableSpace = usableSpace;
    }

    public static List<FileSystemDto> createFileSystems() {
        List<FileSystemDto> fileSystemDtos = new ArrayList<>(0);
        FileSystem fileSystem = SystemInfoUtils.getOperatingSystem().getFileSystem();
        for (OSFileStore fileStore : fileSystem.getFileStores()) {
            FileSystemDto fileSystemDto = new FileSystemDto();
            fileSystemDto.mount = fileStore.getMount();
            fileSystemDto.name = fileStore.getName();
            fileSystemDto.totalSpace = fileStore.getTotalSpace();
            fileSystemDto.volume = fileStore.getVolume();
            fileSystemDto.usableSpace = fileStore.getUsableSpace();
            fileSystemDtos.add(fileSystemDto);
        }
        return fileSystemDtos;
    }


}
