package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import oshi.hardware.HWDiskStore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 磁盘信息
 *
 * @author panda
 * @date 2018-12-31
 */
public class DiskStoreDto {

    private static Map<String, DiskStoreDto> diskStoreMap = new HashMap<>();

    private static final String DISK_STORE_POOL_KEY = "diskStore-schedule-pool-%d";


    static {
        ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1,
                new BasicThreadFactory.Builder().namingPattern(DISK_STORE_POOL_KEY).daemon(true).build());
        executorService.scheduleAtFixedRate(() -> {
            Map<String, DiskStoreDto> diskStoreMapTmp = new HashMap<>();
            List<DiskStoreDto> diskDtos = loadDiskStoreDto();
            for (DiskStoreDto diskDto : diskDtos) {
                DiskStoreDto diskDto2 = diskStoreMap.get(diskDto.name);
                diskStoreMapTmp.put(diskDto.name, diskDto);
                if (diskDto2 != null) {
                    diskDto.readbSpeed = diskDto.reads - diskDto2.reads;
                    diskDto.readSpeed = diskDto.readBytes - diskDto2.readBytes;
                    diskDto.writeSpeed = diskDto.writes - diskDto2.writes;
                    diskDto.writebSpeed = diskDto.writeBytes - diskDto2.writeBytes;
                }
            }
            diskStoreMap = diskStoreMapTmp;
        }, 0, 1, TimeUnit.SECONDS);
    }

    private static List<DiskStoreDto> loadDiskStoreDto() {
        List<DiskStoreDto> diskDtos = new ArrayList<>();

        for (HWDiskStore diskStore : SystemInfoUtils.getDiskStores()) {
            if (diskStore.getReadBytes() <= 0) {
                continue;
            }
            DiskStoreDto diskStoreDto = new DiskStoreDto();
            diskStoreDto.name = diskStore.getName();
            diskStoreDto.size = diskStore.getSize();
            diskStoreDto.model = diskStore.getModel();
            diskStoreDto.reads = diskStore.getReads();
            diskStoreDto.readBytes = diskStore.getReadBytes();
            diskStoreDto.writes = diskStore.getWrites();
            diskStoreDto.writeBytes = diskStore.getWriteBytes();
            diskDtos.add(diskStoreDto);
        }
        return diskDtos;
    }

    public static List<DiskStoreDto> createDiskStores() {
        List<DiskStoreDto> diskDtos = new ArrayList<>();
        for (Map.Entry<String, DiskStoreDto> stringDiskStoreDtoEntry : diskStoreMap.entrySet()) {
            diskDtos.add(stringDiskStoreDtoEntry.getValue());
        }
        return diskDtos;
    }

    private String name;
    private String model;
    private Long size;
    private Long reads;
    private Long readBytes;
    private Long writes;
    private Long writeBytes;


    /**
     * 读取流量速度
     */
    private Long readSpeed = 0L;
    /**
     * 写入流量速度
     */
    private Long writeSpeed = 0L;
    /**
     * 读取包速度
     */
    private Long readbSpeed = 0L;
    /**
     * 写入包速度
     */
    private Long writebSpeed = 0L;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Long getSize() {
        return size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getReads() {
        return reads;
    }

    public void setReads(Long reads) {
        this.reads = reads;
    }

    public Long getReadBytes() {
        return readBytes;
    }

    public void setReadBytes(Long readBytes) {
        this.readBytes = readBytes;
    }

    public Long getWrites() {
        return writes;
    }

    public void setWrites(Long writes) {
        this.writes = writes;
    }

    public Long getWriteBytes() {
        return writeBytes;
    }

    public void setWriteBytes(Long writeBytes) {
        this.writeBytes = writeBytes;
    }

    public Long getReadSpeed() {
        return readSpeed;
    }

    public void setReadSpeed(Long readSpeed) {
        this.readSpeed = readSpeed;
    }

    public Long getWriteSpeed() {
        return writeSpeed;
    }

    public void setWriteSpeed(Long writeSpeed) {
        this.writeSpeed = writeSpeed;
    }

    public Long getReadbSpeed() {
        return readbSpeed;
    }

    public void setReadbSpeed(Long readbSpeed) {
        this.readbSpeed = readbSpeed;
    }

    public Long getWritebSpeed() {
        return writebSpeed;
    }

    public void setWritebSpeed(Long writebSpeed) {
        this.writebSpeed = writebSpeed;
    }
}
