package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import oshi.hardware.ComputerSystem;
import oshi.software.os.OperatingSystem;

/**
 * 操作系统信息
 *
 * @author panda
 * @date 2018-12-30
 */
public class ComputerSystemDto {

    /**
     * 硬件名称
     */
    private String model;
    /**
     * 序列号
     */
    private String serialNumber;
    /**
     * 制造商
     */
    private String manufacturer;


    private String operatingSystemName;

    private int processId;

    private int processCount;

    private int threadCount;

    private int bitness;

    private String hostName;

    private String domainName;

    private Long openFileDescriptors;

    private Long maxFileDescriptors;


    public ComputerSystemDto() {
        ComputerSystem computerSystem = SystemInfoUtils.getComputerSystem();
        model = computerSystem.getModel();
        serialNumber = computerSystem.getSerialNumber();
        manufacturer = computerSystem.getManufacturer();
        OperatingSystem operatingSystem = SystemInfoUtils.getOperatingSystem();
        operatingSystemName = operatingSystem.getManufacturer() + " " + operatingSystem.getFamily() + " " + operatingSystem.getVersionInfo().getVersion();
        processId = operatingSystem.getProcessId();
        processCount = operatingSystem.getProcessCount();
        threadCount = operatingSystem.getThreadCount();
        bitness = operatingSystem.getBitness();
        hostName = operatingSystem.getNetworkParams().getHostName();
        domainName = operatingSystem.getNetworkParams().getDomainName();
        openFileDescriptors = operatingSystem.getFileSystem().getOpenFileDescriptors();
        maxFileDescriptors = operatingSystem.getFileSystem().getMaxFileDescriptors();
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getOperatingSystemName() {
        return operatingSystemName;
    }

    public void setOperatingSystemName(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    public int getProcessId() {
        return processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public int getProcessCount() {
        return processCount;
    }

    public void setProcessCount(int processCount) {
        this.processCount = processCount;
    }

    public int getThreadCount() {
        return threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getBitness() {
        return bitness;
    }

    public void setBitness(int bitness) {
        this.bitness = bitness;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Long getOpenFileDescriptors() {
        return openFileDescriptors;
    }

    public void setOpenFileDescriptors(Long openFileDescriptors) {
        this.openFileDescriptors = openFileDescriptors;
    }

    public Long getMaxFileDescriptors() {
        return maxFileDescriptors;
    }

    public void setMaxFileDescriptors(Long maxFileDescriptors) {
        this.maxFileDescriptors = maxFileDescriptors;
    }


}
