package net.luohuasheng.bee.rest.admin.client.dto.log;

import org.springframework.util.StringUtils;

/**
 * 文件信息
 *
 * @author panda
 * @date 2019-01-04
 */
public class FileDto {
    public String getOpenType() {
        return openType;
    }

    public void setOpenType(String openType) {
        this.openType = openType;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     * 文件类型
     */

    public enum FileType {
        /**
         * 文件夹
         */
        FOLDER("", "#icon-wenjianjia3", ""),
        HTML("html", "#icon-html", "text"),
        XML("xml", "#icon-html", "text"),
        PDF("pdf", "#icon-pdf", "pdf"),
        TXT("txt", "#icon-txt", "text"),
        TMP("tmp", "#icon-tmp", ""),
        DOC("doc", "#icon-doc", "office"),
        JPG("jpg", "#icon-JPG", "image"),
        ZIP("zip", "#icon-ZIP", ""),
        PPT("ppt", "#icon-ppt", "office"),
        DOCX("docx", "#icon-docx1", "office"),
        PPTX("pptx", "#icon-ziyuan", "office"),
        XLS("xls", "#icon-xls", "office"),
        XLSX("xlsx", "#icon-xlsx", "office"),
        RAR("rar", "#icon-rar", ""),
        JAVA("java", "#icon-java", "text"),
        PNG("png", "#icon-png", "image"),
        JPEG("jpeg", "#icon-jpeg", "image"),
        GIF("gif", "#icon-gif", "image"),
        Z7("7z", "#icon-7z", ""),
        SVG("svg", "#icon-svg", ""),
        JSON("json", "#icon-json", "text"),
        CSS("css", "#icon-css", "text"),
        VUE("vue", "#icon-vue-file", "text"),
        LOG("log", "#icon-LOG", "text"),
        YML("yml", "#icon-weizhiwenjian", "text"),
        MD("md", "#icon-weizhiwenjian", "text"),
        PROPERTIES("properties", "#icon-weizhiwenjian", "text"),
        UNKOWN("", "#icon-weizhiwenjian", "text"),
        ;
        private String type;
        private String icon;
        private String openType;

        FileType(String type, String icon, String openType) {
            this.type = type;
            this.icon = icon;
            this.openType = openType;
        }

        private static FileType type(String type) {
            if (!StringUtils.isEmpty(type)) {
                type = type.toLowerCase();
            }
            for (FileType value : FileType.values()) {
                if (value.type.equals(type)) {
                    return value;
                }
            }
            return UNKOWN;
        }
    }

    private String fileName;
    private Boolean isDirectory;
    private Long length;
    private Long lastModified;
    private String fileType;
    private String openType;
    private String icon;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }


    public Boolean getDirectory() {
        return isDirectory;
    }

    public void setDirectory(Boolean directory) {
        isDirectory = directory;
    }

    public Long getLength() {
        return length;
    }

    public void setLength(Long length) {
        this.length = length;
    }


    public Long getLastModified() {
        return lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        if (!isDirectory) {
            this.fileType = fileType;
            FileType fileType1 = FileType.type(fileType);
            this.icon = fileType1.icon;
            this.openType = fileType1.openType;
        } else {
            this.icon = FileType.FOLDER.icon;
        }

    }
}
