package net.luohuasheng.bee.rest.admin.client.dto.db;

import java.util.concurrent.atomic.AtomicLong;

/**
 * Sql统计
 *
 * @author panda
 * @date 2019-06-01
 */
public class SqlStatistics {

    private String sql;
    private AtomicLong visitNumber = new AtomicLong(0);
    private AtomicLong errorNumber = new AtomicLong(0);

    private Long averageTime = 0L;
    private Long maxTime = Long.MIN_VALUE;
    private Long minTime = Long.MAX_VALUE;

    public String getSql() {
        return sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public AtomicLong getVisitNumber() {
        return visitNumber;
    }

    public void setVisitNumber(AtomicLong visitNumber) {
        this.visitNumber = visitNumber;
    }

    public Long getAverageTime() {
        return averageTime;
    }

    public void setAverageTime(Long averageTime) {
        this.averageTime = (averageTime * visitNumber.get() + averageTime) / (visitNumber.get() + 1);
    }

    public Long getMaxTime() {
        return maxTime;
    }

    public void setMaxTime(Long maxTime) {
        this.maxTime = Long.max(maxTime, this.maxTime);
    }

    public Long getMinTime() {
        return minTime;
    }

    public void setMinTime(Long minTime) {
        this.minTime = Long.min(minTime, this.minTime);
    }

    public AtomicLong getErrorNumber() {
        return errorNumber;
    }

    public void setErrorNumber(AtomicLong errorNumber) {
        this.errorNumber = errorNumber;
    }
}
