

package net.luohuasheng.bee.rest.admin.client.config;


import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * The type Swagger web mvc configurer.
 *
 * @author bnasslahsen
 */
@Configuration
public class ClientWebConfig implements WebMvcConfigurer {


    private final ClientProperties clientProperties;

    public ClientWebConfig(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/admin-ui/**").addResourceLocations("classpath:/admin/admin-ui/");
        registry.addResourceHandler(clientProperties.getName()).addResourceLocations("classpath:/admin/index.html");

    }

}
