package net.luohuasheng.bee.rest.admin.client.config;

import io.micrometer.core.instrument.LocalMeterRegistry;
import net.luohuasheng.bee.rest.admin.client.interceptor.ClientFilter;
import net.luohuasheng.bee.rest.admin.client.interceptor.SqlInterceptor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.*;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextListener;

/**
 * TODO 类描述
 *
 * @author panda
 * @date 2019-06-25
 */
@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@PropertySource(value = {"classpath:client.properties", "classpath:git.properties"}, ignoreResourceNotFound = true)
@ComponentScan("net.luohuasheng.bee.rest.admin.client")
@EnableConfigurationProperties(ClientProperties.class)
@Import(ClientWebConfig.class)
public class ClientConfig {

    @Bean
    public LocalMeterRegistry simpleMeterRegistry() {
        return new LocalMeterRegistry();
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    @Order(400)
    public SqlInterceptor sqlInterceptor() {
        return new SqlInterceptor();
    }

    @Bean
    public FilterRegistrationBean customFilter() {
        FilterRegistrationBean<ClientFilter> filterBean = new FilterRegistrationBean<>();
        filterBean.setFilter(new ClientFilter());
        filterBean.setName("FilterController");
        filterBean.addUrlPatterns("/*");
        return filterBean;
    }

}
