package net.luohuasheng.bee.rest.admin.client.components;

import net.luohuasheng.bee.rest.admin.client.dto.db.DbInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Redis处理服务
 *
 * @author panda
 * @date 2019-05-16
 */
public class RedisComponent implements BasicComponent {

    @Autowired(required = false)
    private List<JedisConnectionFactory> redisConnectionFactories;


    public List<DbInfo> dbInfos() {
        List<DbInfo> dbInfos = new ArrayList<>();
        for (int i = 0; !CollectionUtils.isEmpty(redisConnectionFactories) && i < redisConnectionFactories.size(); i++) {
            JedisConnectionFactory redisConnectionFactory = redisConnectionFactories.get(i);
            DbInfo dbInfo = new DbInfo();
            dbInfo.setType("redis");
            dbInfo.setHost(redisConnectionFactory.getHostName());
            dbInfo.setIndex(i);

            dbInfo.setPort(String.valueOf(redisConnectionFactory.getPort()));
            if (checkDbInfo(dbInfo, dbInfos)) {
                dbInfos.add(dbInfo);
            }
        }

        return dbInfos;
    }

    public List<JedisConnectionFactory> getRedisConnectionFactories() {
        return redisConnectionFactories;
    }


}
