package net.luohuasheng.bee.rest.admin.client.components;

import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.LocalMeterRegistry;
import net.luohuasheng.bee.jdbc.tools.common.utils.StructureUtils;
import net.luohuasheng.bee.jdbc.tools.component.structure.dto.TableDto;
import net.luohuasheng.bee.proxy.core.utils.thread.DefaultThreadFactory;
import net.luohuasheng.bee.rest.admin.client.dto.db.DbInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;

/**
 * 关系型数据库处理服务
 *
 * @author panda
 * @date 2019-05-16
 */
@Component
@ConditionalOnClass(DataSource.class)
public class DataSourceComponent implements BasicComponent {


    private ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(20, new DefaultThreadFactory("column-pool-%d"));

    private Map<String, HikariDataSource> dataSourceMap = new HashMap<>();
    private Map<String, DbInfo> dbinfo = new HashMap<>();
    //    private Map<DataSource, HikariStatData> statDataMap = new HashMap<>();
    @Autowired
    private LocalMeterRegistry clientMeterRegistry;

    @Autowired(required = false)
    private List<DataSource> dataSources;

    @PostConstruct
    private void init() {
//        for (int i = 0; !CollectionUtils.isEmpty(dataSources) && i < dataSources.size(); i++) {
//            DataSource dataSource = dataSources.get(i);
//            HikariStatData hikariStatData = new HikariStatData(dataSource, clientMeterRegistry);
//            statDataMap.put(dataSource, hikariStatData);
//
//        }
    }


//    public List<DbInfo> dbInfos() {
//        List<DbInfo> dbInfos = new ArrayList<>();
//        for (int i = 0; !CollectionUtils.isEmpty(dataSources) && i < dataSources.size(); i++) {
//            DataSource dataSource = dataSources.get(i);
//            DbInfo dbInfo = dbinfo.get(dataSource);
//            if (dbInfo == null) {
//                dbInfo = new DbInfo();
//                dbinfo.put(dataSource.getName(), dbInfo);
//                JdbcUrlSplitter url = new JdbcUrlSplitter(dataSource.getJdbcUrl());
//                dbInfo.setType(DbUtils.getType(dataSource.getDataSourceClassName()));
//                dbInfo.setHost(url.host);
//                dbInfo.setPort(url.port);
//                dbInfo.setIndex(i);
//                String query = dataSource.getConnectionTestQuery();
//                dataSource = DbUtils.dataSource(dataSource.getJdbcUrl(), dataSource.getUsername(), dataSource.getPassword());
//                dataSource.setConnectionTestQuery(query);
//                Connection connection = null;
//                try {
//                    connection = dataSource.getConnection();
//                    dbInfo.setDb(connection.getCatalog());
//                } catch (SQLException e) {
//                    e.printStackTrace();
//                } finally {
//                    if (connection != null) {
//                        try {
//                            connection.close();
//                        } catch (SQLException e) {
//                            e.printStackTrace();
//                        }
//                        dataSource.evictConnection(connection);
//                        dataSource.close();
//                    }
//                }
//                if (StringUtils.isEmpty(dbInfo.getDb())) {
//                    dbInfo.setDb(dataSource.getUsername());
//                }
//            }
//            dbInfos.add(dbInfo);
//
//        }
//
//        return dbInfos;
//    }

    public List<DataSource> getDataSources() {
        return dataSources;
    }

//    public HikariStatData getHikariStatData(Integer index) {
//        return statDataMap.get(dataSources.get(index));
//    }

    public List<List<TableDto>> getTables() throws SQLException, ExecutionException, InterruptedException {
        List<List<TableDto>> tables = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dataSources)) {
            for (DataSource dataSource : dataSources) {
                List<TableDto> list = StructureUtils.loadTables(dataSource, "table", true);
                tables.add(list);
            }

        }
        return tables;
    }

}
