package net.luohuasheng.bee.rest.admin.client.components;

import net.luohuasheng.bee.rest.admin.client.dto.db.DbInfo;

import java.util.List;

/**
 * 处理类
 *
 * @author panda
 * @date 2019-05-16
 */
public interface BasicComponent {
    /**
     * 检测是否
     *
     * @param dbInfo  连接信息
     * @param dbInfos 连接数据集合
     * @return 是否包含
     */
    default boolean checkDbInfo(DbInfo dbInfo, List<DbInfo> dbInfos) {

        for (DbInfo info : dbInfos) {
            if (info.getHost().equals(dbInfo.getHost()) && info.getPort().equals(dbInfo.getPort())) {
                return false;
            }
        }
        return true;

    }

}
