package net.luohuasheng.bee.rest.admin.client.aop;

import net.luohuasheng.bee.rest.admin.client.config.ClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.DynamicMethodMatcherPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/**
 * @author panda
 */
@Component
public class DynamicPointcut extends DynamicMethodMatcherPointcut {
    private final static Logger logger = LoggerFactory.getLogger(DynamicPointcut.class);


    @Autowired
    private ClientProperties clientProperties;
    @Autowired
    private Environment environment;

    @Override
    public boolean matches(@NonNull Method method, @NonNull Class<?> aClass, @NonNull Object... objects) {
        return true;
    }

    @Override
    public ClassFilter getClassFilter() {
        return aClass -> !(Modifier.isFinal(aClass.getModifiers()) || (aClass.isAssignableFrom(Exception.class)) || !checkRequestPackages(aClass));
    }

    public boolean checkRequestPackages(Class<?> aClass) {
        if (aClass.getCanonicalName() == null) {
            return false;
        }
        boolean isOk = false;
        for (String includePackage : clientProperties.getPackagesInclude()) {
            if (aClass.getCanonicalName().startsWith(includePackage)) {
                isOk = true;
                break;
            }
        }
        if (clientProperties.getPackagesInclude().length == 0) {
            if ((aClass.getAnnotation(RestController.class) != null
                    || aClass.getAnnotation(Controller.class) != null
                    || aClass.getAnnotation(Service.class) != null
                    || aClass.getAnnotation(Component.class) != null
                    || aClass.getAnnotation(Repository.class) != null)
                    && !aClass.getName().startsWith("net.luohuasheng.bee.rest.admin.client")
            ) {
                return true;
            }
        }
        for (String excludePackage : clientProperties.getPackagesExclude()) {
            if (aClass.getCanonicalName().startsWith(excludePackage)) {
                return false;
            }
        }
        return isOk;
    }

}
