<html class=" " lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>接口文档</title>
    <link rel="icon" href="/favicon.ico">
    <meta name="description" content="为简化开发而生">
    <style>
        .page {
            padding-bottom: 2rem
        }

        .sidebar-group:not(.first) {
            margin-top: 1em
        }

        .sidebar-group .sidebar-group {
            padding-left: .5em
        }

        .sidebar-group:not(.collapsable) .sidebar-heading {
            cursor: auto;
            color: inherit;
        }

        .sidebar-heading {
            color: #999;
            transition: color .15s ease;
            cursor: pointer;
            font-size: 1.1em;
            font-weight: 700;
            padding: 0 1.5rem;
            margin-top: 0;
            margin-bottom: .5rem
        }

        .sidebar-heading.open,
        .sidebar-heading:hover {
            color: inherit
        }

        .sidebar-heading .arrow {
            position: relative;
            top: -.12em;
            left: .5em
        }

        .sidebar-heading:.open .arrow {
            top: -.18em
        }

        .sidebar-group-items {
            transition: height .1s ease-out;
            overflow: hidden
        }

        .sidebar ul {
            padding: 0;
            margin: 0;
            list-style-type: none;
        }

        .sidebar a {
            display: inline-block
        }

        .sidebar .nav-links {
            display: none;
            border-bottom: 1px solid #eaecef;
            padding: .5rem 0 .75rem 0
        }

        .sidebar .nav-links a {
            font-weight: 600
        }

        .sidebar .nav-links .nav-item,
        .sidebar .nav-links .repo-link {
            display: block;
            line-height: 1.25rem;
            font-size: 1.1em;
            padding: .5rem 0 .5rem 1.5rem
        }


        @media (max-width: 719px) {
            .sidebar .nav-links {
                display: block
            }

            .sidebar .nav-links .dropdown-wrapper .nav-dropdown .dropdown-item a.router-link-active:after {
                top: calc(1rem - 2px)
            }

            .sidebar .sidebar-links {
                padding: 1rem 0
            }
        }

        .content code {
            color: #476582;
            padding: .25rem .5rem;
            margin: 0;
            font-size: .85em;
            background-color: rgba(27, 31, 35, .05);
            border-radius: 3px
        }

        .content pre,
        .content pre[class*=language-] {
            line-height: 1.4;
            padding: 1.25rem 1.5rem;
            margin: .85rem 0;
            background-color: #282c34;
            border-radius: 6px;
            overflow: auto
        }

        .content pre[class*=language-] code,
        .content pre code {
            color: #fff;
            padding: 0;
            background-color: transparent;
            border-radius: 0
        }

        div[class*=language-] .highlight-lines .highlighted {
            background-color: rgba(0, 0, 0, .66)
        }

        body,
        html {
            padding: 0;
            margin: 0
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue, sans-serif;
            -webkit-font-smoothing: antialiased;
            /*! -moz-osx-font-smoothing:grayscale; *//*! font-size:16px; *//*! color:#2c3e50 */
        }

        .page {
            padding-left: 20rem
        }

        .navbar {
            z-index: 20;
            right: 0;
            height: 3.6rem;
            background-color: #fff;
            box-sizing: border-box;
            border-bottom: 1px solid #eaecef
        }

        .navbar,
        .sidebar-mask {
            position: fixed;
            top: 0;
            left: 0
        }

        .sidebar-mask {
            z-index: 9;
            width: 100vw;
            height: 100vh;
            display: none
        }

        .sidebar {
            font-size: 15px;
            background-color: #fff;
            width: 20rem;
            position: fixed;
            z-index: 10;
            margin: 0;
            top: 0;
            left: 0;
            bottom: 0;
            box-sizing: border-box;
            border-right: 1px solid #eaecef;
            overflow-y: auto
        }

        .content:not(.custom) > :first-child {
            margin-top: 3.6rem
        }

        .content:not(.custom) a:hover {
            text-decoration: underline
        }

        .content:not(.custom) p.demo {
            padding: 1rem 1.5rem;
            border: 1px solid #ddd;
            border-radius: 4px
        }

        .content:not(.custom) img {
            max-width: 100%
        }

        .content.custom {
            padding: 0;
            margin: 0
        }

        .content.custom img {
            max-width: 100%
        }

        a {
            font-weight: 500;
            text-decoration: none
        }

        a.sidebar-link.active {
            font-weight: 600;
            color: #3eaf7c;
            border-left-color: #3eaf7c;
        }

        a.sidebar-link:hover {
            color: #3eaf7c;
        }

        a,
        p a code {
            color: #3eaf7c
        }

        p a code {
            font-weight: 400
        }

        kbd {
            background: #eee;
            border: .15rem solid #ddd;
            border-bottom: .25rem solid #ddd;
            border-radius: .15rem;
            padding: 0 .15em
        }

        blockquote {
            font-size: 1.2rem;
            color: #999;
            border-left: .25rem solid #dfe2e5;
            margin-left: 0;
            padding-left: 1rem
        }

        ol,
        ul {
            padding-left: 1.2em;
        }

        strong {
            font-weight: 600
        }


        @media (max-width: 959px) {
            .sidebar {
                font-size: 15px;
                width: 16.4rem
            }

            .page {
                padding-left: 16.4rem
            }
        }

        @media (max-width: 719px) {
            .sidebar {
                top: 0;
                padding-top: 3.6rem;
                transform: translateX(-100%);
                transition: transform .2s ease
            }

            .page {
                padding-left: 0
            }

            .theme-container.sidebar-open .sidebar {
                transform: translateX(0)
            }

            .theme-container.no-navbar .sidebar {
                padding-top: 0
            }
        }

        @media (max-width: 419px) {
            h1 {
                font-size: 1.9rem
            }

            .content div[class*=language-] {
                margin: .85rem -1.5rem;
                border-radius: 0
            }
        }

        .icon.outbound {
            color: #aaa;
            display: inline-block
        }

        .sidebar .sidebar-sub-headers {
            padding-left: 1rem;
            font-size: .95em
        }

        a.sidebar-link {
            font-weight: 400;
            display: inline-block;
            color: #2c3e50;
            border-left: .25rem solid transparent;
            padding: .35rem 1rem .35rem 1.25rem;
            line-height: 1.4;
            width: 100%;
            box-sizing: border-box
        }


        a.sidebar-link:hover {
            color: #3eaf7c
        }

        a.sidebar-link.active {
            font-weight: 600;
            color: #3eaf7c;
            border-left-color: #3eaf7c
        }

        .sidebar-group a.sidebar-link {
            padding-left: 2rem
        }

        .sidebar-sub-headers a.sidebar-link {
            padding-top: .25rem;
            padding-bottom: .25rem;
            border-left: none
        }

        .sidebar-sub-headers a.sidebar-link.active {
            font-weight: 500
        }

        .content:not(.custom) > :first-child {
            margin-top: 0;
        }

        table {
            border-collapse: collapse;
            margin: 1rem 0;
            display: block;
            overflow-x: auto;
        }

        tbody {
            width: 100%;
        }

        .content {
            padding-left: 5px;
        }

        tr {
            border-top: 1px solid #dfe2e5;
        }

        td, th {
            border: 1px solid #dfe2e5;
            padding: .6em 1em;
            height: 40px;
        }

        th {
            background-color: darkgray;
        }

        .custom-block {
            padding-left: 20px;
        }

    </style>

</head>
<body>
<div id="app">
    <div class="theme-container">
        <div class="sidebar">
            <ul class="sidebar-links">
                <li>
                    <ul class="sidebar-group-items">
                        <li><a href="#1" class=" sidebar-link">1. 总体概述</a>
                            <ul class="sidebar-sub-headers">
                                <li class="sidebar-sub-header">
                                    <a href="#1.1" class="sidebar-link">1.1. 接口文档描述</a>
                                </li>
                                <li class="sidebar-sub-header">
                                    <a href="#1.2" class="sidebar-link">1.2. 阅读对象</a>
                                </li>
                                <li class="sidebar-sub-header">
                                    <a href="#1.3" class="sidebar-link">1.3. 错误编码解释</a>
                                </li>
                            </ul>
                        </li>

                    </ul>
                </li>
                <li>
                    <ul class="sidebar-group-items">
                        <li><a href="#2" class=" sidebar-link">2. 接口实现机制</a>
                            <ul class="sidebar-sub-headers">
                                <li class="sidebar-sub-header">
                                    <a href="#2.1" class="sidebar-link">2.1. 通讯方式</a>
                                </li>
                                <li class="sidebar-sub-header">
                                    <a href="#2.2" class="sidebar-link">2.2. 通讯协议</a>
                                </li>
                                <li class="sidebar-sub-header">
                                    <a href="#2.3" class="sidebar-link">2.3. 消息格式</a>
                                </li>
                                <li class="sidebar-sub-header">
                                    <a href="#2.4" class="sidebar-link">2.4. 字符编码</a>
                                </li>
                            </ul>
                        </li>

                    </ul>
                </li>
                <li>
                    <ul class="sidebar-group-items">
                        <li><a href="#3" class=" sidebar-link">3. 接口定义</a>
                            <ul class="sidebar-sub-headers">
                                <#list tags as tag>
                                    <li class="sidebar-sub-header">
                                        <a href="#3.${tag_index+1}" class="sidebar-link">3.${tag_index+1}
                                            . ${((tag.name)!"未知")?html} </a>
                                        <ul class="sidebar-sub-headers">
                                            <li class="sidebar-sub-header">
                                                <a href="#3.${tag_index+1}.1" class="sidebar-link">3.${tag_index+1}.1.
                                                    模块描述</a>
                                            </li>
                                            <li class="sidebar-sub-header">
                                                <a href="#3.${tag_index+1}.2" class="sidebar-link">3.${tag_index+1}.2.
                                                    接口列表</a>
                                                <#list tag.paths as path>

                                                    <ul class="sidebar-sub-headers">
                                                        <li class="sidebar-sub-header"><a
                                                                    href="#3.${tag_index+1}.2.${path_index+1}"
                                                                    class="sidebar-link">3.${tag_index+1}
                                                                .2.${path_index+1}.
                                                                ${((path.name)!"暂无")?html}</a>
                                                            <ul class="sidebar-sub-headers">
                                                                <li class="sidebar-sub-header"><a
                                                                            href="#3.${tag_index+1}.2.${path_index+1}.1"
                                                                            class="sidebar-link">3.${tag_index+1}
                                                                        .2.${path_index+1}.1.
                                                                        业务描述</a>
                                                                </li>
                                                                <li class="sidebar-sub-header"><a
                                                                            href="#3.${tag_index+1}.2.${path_index+1}.2"
                                                                            class="sidebar-link">3.${tag_index+1}
                                                                        .2.${path_index+1}.2.
                                                                        请求方式</a>
                                                                </li>
                                                                <li class="sidebar-sub-header"><a
                                                                            href="#3.${tag_index+1}.2.${path_index+1}.3"
                                                                            class="sidebar-link">3.${tag_index+1}
                                                                        .2.${path_index+1}.3.
                                                                        请求地址</a>
                                                                </li>
                                                                <li class="sidebar-sub-header"><a
                                                                            href="#3.${tag_index+1}.2.${path_index+1}.4"
                                                                            class="sidebar-link">3.${tag_index+1}
                                                                        .2.${path_index+1}.4.
                                                                        请求报文</a>
                                                                </li>
                                                            </ul>
                                                        </li>

                                                    </ul>
                                                </#list>
                                            </li>

                                        </ul>
                                    </li>
                                </#list>
                            </ul>
                        </li>

                    </ul>
                </li>
                <li>
                    <ul class="sidebar-group-items">
                        <li><a href="#4" class=" sidebar-link">4. 下载</a>
                        </li>

                    </ul>
                </li>
            </ul>
        </div>
        <div class="page">
            <div class="content">
                <h1 id="1"> 1. 总体概述
                    <button style="float: right;font-size: 1.2rem;" id="open"
                            onclick="window.open(location.href)">窗口打开
                    </button>
                </h1>

                <h2 id="1.1">1.1. 接口文档描述</h2>
                <div class="tip custom-block">
                    ${((info.description)!"未知")?html}
                </div>
                <h2 id="1.2">1.2. 阅读对象</h2>
                <div class="tip custom-block">
                    项目经理、技术经理、app开发人员、微信服务号开发人员、后端开发人员等。
                </div>
                <h2 id="1.3">1.3. 错误编码解释</h2>
                <div class="tip custom-block">
                    <table>
                        <tr>
                            <th width="30%">编码</th>
                            <th width="70%">解释</th>
                        </tr>
                        <#list messages?keys as item>
                            <#if item?length!=3>
                                <tr>
                                    <td>${item}</td>
                                    <td>${messages[item]}</td>
                                </tr>
                            </#if>
                        </#list>
                    </table>
                </div>
            </div>
            <div class="content">
                <h1 id="2">2. 接口实现机制</h1>
                <h2 id="2.1">2.1. 通讯方式</h2>
                <div class="tip custom-block">
                    采用HTTP方式进行通信。
                </div>
                <h2 id="2.2">2.2. 通讯协议</h2>
                <div class="tip custom-block">
                    restful协议
                </div>
                <h2 id="2.3">2.3. 消息格式</h2>
                <div class="tip custom-block">
                    请求消息和响应消息均为JSON格式的字符串
                </div>
                <h2 id="2.4">2.4. 字符编码</h2>
                <div class="tip custom-block">
                    请求消息和响应消息的字符编码均为UTF-8编码
                </div>
            </div>
            <div class="content">
                <h1 id="3"> 3. 接口定义</h1>
                <#list tags as tag>
                    <h2 id="3.${tag_index+1}">3.${tag_index+1}. ${((tag.name)!"未知")?html}</h2>
                    <h3 id="3.${tag_index+1}.1">3.${tag_index+1}.1. 模块描述</h3>
                    <div class="tip custom-block">
                        ${((tag.description)!"未知")?html}
                    </div>
                    <h3 id="3.${tag_index+1}.2">3.${tag_index+1}.2. 接口列表</h3>
                    <#list tag.paths as path>
                        <h4 id="3.${tag_index+1}.2.${path_index+1}">3.${tag_index+1}.2.${path_index+1}
                            . ${((path.name)!"暂无")?html}</h4>
                        <h5 id="3.${tag_index+1}.2.${path_index+1}.1">3.${tag_index+1}.2.${path_index+1}.1. 业务描述</h5>
                        <div class="tip custom-block">
                            ${((path.description)!"暂无")?html}
                        </div>
                        <h5 id="3.${tag_index+1}.2.${path_index+1}.2">3.${tag_index+1}.2.${path_index+1}.2. 请求方式</h5>
                        <div class="tip custom-block">
                            ${path.method}
                        </div>
                        <h5 id="3.${tag_index+1}.2.${path_index+1}.3">3.${tag_index+1}.2.${path_index+1}.3. 请求地址</h5>
                        <div class="tip custom-block">
                            ${((path.url)!"暂无")?html}
                        </div>
                        <h5 id="3.${tag_index+1}.2.${path_index+1}.4">3.${tag_index+1}.2.${path_index+1}.4. 请求报文</h5>
                        <div class="tip custom-block">
                            <#if  path.parameters??>
                                <table>
                                    <tr>
                                        <th>节点</th>
                                        <th>父节点</th>
                                        <th>可为空</th>
                                        <th>数据类型</th>
                                        <th>查询类型</th>
                                        <th>节点说明</th>
                                    </tr>
                                    <#list path.parameters as parameter>
                                        <tr>
                                            <td>${parameter.name}</td>
                                            <td>${parameter.parentName}</td>
                                            <td>${parameter.required?string("是","否")}</td>
                                            <td>${parameter.type?html}</td>
                                            <td>${parameter.queryType}</td>
                                            <td>${(parameter.description!"暂无")?html}</td>
                                        </tr>
                                    </#list>
                                </table>

                            <#else>
                                无
                            </#if>
                        </div>
                        <h5 id="3.${tag_index+1}.2.${path_index+1}.5">3.${tag_index+1}.2.${path_index+1}.5. 响应报文</h5>
                        <div class="tip custom-block">
                            <#if path.responses??>

                                <table>
                                    <tr>
                                        <th>节点</th>
                                        <th>父节点</th>
                                        <th>数据类型</th>
                                        <th>节点说明</th>
                                    </tr>
                                    <#list path.responses as response>

                                        <tr>
                                            <td>${response.name}</td>
                                            <td>${response.parentName}</td>
                                            <td>${response.type?html}</td>
                                            <td>${(response.description!"暂无")?html}</td>
                                        </tr>
                                    </#list>
                                </table>
                            <#else >
                                无
                            </#if>
                        </div>
                    </#list>
                </#list>
            </div>
            <div class="content">
                <h1 id="4"> 4. 下载</h1>
                <div class="tip custom-block">
                    <a href="swaggerOutDocx">下载链接</a>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function addPraiseNum() {
        var praiseObjs = document.getElementsByTagName('a');
        for (let i = 0; i < praiseObjs.length; i++) {
            let praiseObj = praiseObjs[i];
            praiseObj.onclick = function (obj) {
                let className = obj.target.getAttribute("class");
                className = className.replace("active", "")
                var praiseObjs2 = document.getElementsByTagName('a');
                for (let j = 0; j < praiseObjs2.length; j++) {
                    let praiseObj2 = praiseObjs2[j];
                    if (praiseObj2 === obj.target) {
                        praiseObj2.setAttribute("class", className + " active");
                    } else {
                        praiseObj2.setAttribute("class", className);
                    }

                }
            }
        }
    }

    addPraiseNum();
</script>
</body>
</html>