<html class=" " lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>数据库文档</title>
    <link rel="icon" href="/favicon.ico">
    <meta name="description" content="为简化开发而生">
    <style>
        .page {
            padding-bottom: 2rem
        }

        .sidebar-group:not(.first) {
            margin-top: 1em
        }

        .sidebar-group .sidebar-group {
            padding-left: .5em
        }

        .sidebar-group:not(.collapsable) .sidebar-heading {
            cursor: auto;
            color: inherit;
        }

        .sidebar-heading {
            color: #999;
            transition: color .15s ease;
            cursor: pointer;
            font-size: 1.1em;
            font-weight: 700;
            padding: 0 1.5rem;
            margin-top: 0;
            margin-bottom: .5rem
        }

        .sidebar-heading.open,
        .sidebar-heading:hover {
            color: inherit
        }

        .sidebar-heading .arrow {
            position: relative;
            top: -.12em;
            left: .5em
        }

        .sidebar-heading:.open .arrow {
            top: -.18em
        }

        .sidebar-group-items {
            transition: height .1s ease-out;
            overflow: hidden
        }

        .sidebar ul {
            padding: 0;
            margin: 0;
            list-style-type: none;
        }

        .sidebar a {
            display: inline-block
        }

        .sidebar .nav-links {
            display: none;
            border-bottom: 1px solid #eaecef;
            padding: .5rem 0 .75rem 0
        }

        .sidebar .nav-links a {
            font-weight: 600
        }

        .sidebar .nav-links .nav-item,
        .sidebar .nav-links .repo-link {
            display: block;
            line-height: 1.25rem;
            font-size: 1.1em;
            padding: .5rem 0 .5rem 1.5rem
        }


        @media (max-width: 719px) {
            .sidebar .nav-links {
                display: block
            }

            .sidebar .nav-links .dropdown-wrapper .nav-dropdown .dropdown-item a.router-link-active:after {
                top: calc(1rem - 2px)
            }

            .sidebar .sidebar-links {
                padding: 1rem 0
            }
        }

        .content code {
            color: #476582;
            padding: .25rem .5rem;
            margin: 0;
            font-size: .85em;
            background-color: rgba(27, 31, 35, .05);
            border-radius: 3px
        }

        .content pre,
        .content pre[class*=language-] {
            line-height: 1.4;
            padding: 1.25rem 1.5rem;
            margin: .85rem 0;
            background-color: #282c34;
            border-radius: 6px;
            overflow: auto
        }

        .content pre[class*=language-] code,
        .content pre code {
            color: #fff;
            padding: 0;
            background-color: transparent;
            border-radius: 0
        }

        div[class*=language-] .highlight-lines .highlighted {
            background-color: rgba(0, 0, 0, .66)
        }

        body,
        html {
            padding: 0;
            margin: 0
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue, sans-serif;
            -webkit-font-smoothing: antialiased;
            /*! -moz-osx-font-smoothing:grayscale; *//*! font-size:16px; *//*! color:#2c3e50 */
        }

        .page {
            padding-left: 20rem
        }

        .navbar {
            z-index: 20;
            right: 0;
            height: 3.6rem;
            background-color: #fff;
            box-sizing: border-box;
            border-bottom: 1px solid #eaecef
        }

        .navbar,
        .sidebar-mask {
            position: fixed;
            top: 0;
            left: 0
        }

        .sidebar-mask {
            z-index: 9;
            width: 100vw;
            height: 100vh;
            display: none
        }

        .sidebar {
            font-size: 15px;
            background-color: #fff;
            width: 20rem;
            position: fixed;
            z-index: 10;
            margin: 0;
            top: 0;
            left: 0;
            bottom: 0;
            box-sizing: border-box;
            border-right: 1px solid #eaecef;
            overflow-y: auto
        }

        .content:not(.custom) > :first-child {
            margin-top: 3.6rem
        }

        .content:not(.custom) a:hover {
            text-decoration: underline
        }

        .content:not(.custom) p.demo {
            padding: 1rem 1.5rem;
            border: 1px solid #ddd;
            border-radius: 4px
        }

        .content:not(.custom) img {
            max-width: 100%
        }

        .content.custom {
            padding: 0;
            margin: 0
        }

        .content.custom img {
            max-width: 100%
        }

        a {
            font-weight: 500;
            text-decoration: none
        }

        a.sidebar-link.active {
            font-weight: 600;
            color: #3eaf7c;
            border-left-color: #3eaf7c;
        }

        a.sidebar-link:hover {
            color: #3eaf7c;
        }

        a,
        p a code {
            color: #3eaf7c
        }

        p a code {
            font-weight: 400
        }

        kbd {
            background: #eee;
            border: .15rem solid #ddd;
            border-bottom: .25rem solid #ddd;
            border-radius: .15rem;
            padding: 0 .15em
        }

        blockquote {
            font-size: 1.2rem;
            color: #999;
            border-left: .25rem solid #dfe2e5;
            margin-left: 0;
            padding-left: 1rem
        }

        ol,
        ul {
            padding-left: 1.2em;
        }

        strong {
            font-weight: 600
        }


        @media (max-width: 959px) {
            .sidebar {
                font-size: 15px;
                width: 16.4rem
            }

            .page {
                padding-left: 16.4rem
            }
        }

        @media (max-width: 719px) {
            .sidebar {
                top: 0;
                padding-top: 3.6rem;
                transform: translateX(-100%);
                transition: transform .2s ease
            }

            .page {
                padding-left: 0
            }

            .theme-container.sidebar-open .sidebar {
                transform: translateX(0)
            }

            .theme-container.no-navbar .sidebar {
                padding-top: 0
            }
        }

        @media (max-width: 419px) {
            h1 {
                font-size: 1.9rem
            }

            .content div[class*=language-] {
                margin: .85rem -1.5rem;
                border-radius: 0
            }
        }

        .icon.outbound {
            color: #aaa;
            display: inline-block
        }

        .sidebar .sidebar-sub-headers {
            padding-left: 1rem;
            font-size: .95em
        }

        a.sidebar-link {
            font-weight: 400;
            display: inline-block;
            color: #2c3e50;
            border-left: .25rem solid transparent;
            padding: .35rem 1rem .35rem 1.25rem;
            line-height: 1.4;
            width: 100%;
            box-sizing: border-box
        }


        a.sidebar-link:hover {
            color: #3eaf7c
        }

        a.sidebar-link.active {
            font-weight: 600;
            color: #3eaf7c;
            border-left-color: #3eaf7c
        }

        .sidebar-group a.sidebar-link {
            padding-left: 2rem
        }

        .sidebar-sub-headers a.sidebar-link {
            padding-top: .25rem;
            padding-bottom: .25rem;
            border-left: none
        }

        .sidebar-sub-headers a.sidebar-link.active {
            font-weight: 500
        }

        .content:not(.custom) > :first-child {
            margin-top: 0;
        }

        table {
            border-collapse: collapse;
            margin: 1rem 0;
            display: block;
            overflow-x: auto;
        }

        tbody {
            width: 100%;
        }

        .content {
            padding-left: 5px;
        }

        tr {
            border-top: 1px solid #dfe2e5;
        }

        td, th {
            border: 1px solid #dfe2e5;
            padding: .6em 1em;
            height: 40px;
        }

        th {
            background-color: darkgray;
        }

        .custom-block {
            padding-left: 20px;
        }

    </style>

</head>
<body>
<div id="app">
    <div class="theme-container">
        <div class="sidebar">
            <ul class="sidebar-links">
                <li>
                    <ul class="sidebar-group-items">
                        <li><a href="#1" class=" sidebar-link">1. 总体概述</a>
                            <ul class="sidebar-sub-headers">
                                <li class="sidebar-sub-header">
                                    <a href="#1.1" class="sidebar-link">1.1. 文档描述</a>
                                </li>
                                <li class="sidebar-sub-header">
                                    <a href="#1.2" class="sidebar-link">1.2. 阅读对象</a>
                                </li>
                                <li class="sidebar-sub-header">
                                    <a href="#1.3" class="sidebar-link">1.3. 名称解释</a>
                                </li>
                            </ul>
                        </li>

                    </ul>
                </li>
                <li>
                    <ul class="sidebar-group-items">
                        <li><a href="#2" class=" sidebar-link">2. 数据表清单</a></li>

                    </ul>
                </li>
                <li>
                    <ul class="sidebar-group-items">
                        <li><a href="#3" class=" sidebar-link">3. 数据表定义</a>
                            <ul class="sidebar-sub-headers">
                                <#list tableUsers?keys as prop>
                                    <li class="sidebar-sub-header">
                                        <a href="#3.${prop_index+1}" class="sidebar-link">3.${prop_index+1}
                                            . ${prop} </a>
                                        <ul class="sidebar-sub-headers">
                                            <li class="sidebar-sub-header">
                                                <a href="#3.${prop_index+1}.1" class="sidebar-link">3.${prop_index+1}.1.
                                                    用户描述</a>
                                            </li>
                                            <li class="sidebar-sub-header">
                                                <a href="#3.${prop_index+1}.2" class="sidebar-link">3.${prop_index+1}.2.
                                                    数据表列表</a>

                                                <ul class="sidebar-sub-headers">
                                                    <#list   tableUsers[prop]  as table>
                                                        <li class="sidebar-sub-header"><a
                                                                    href="#3.${prop_index+1}.2.${table_index+1}"
                                                                    class="sidebar-link">3.${prop_index+1}.2.${table_index+1}.
                                                                ${table.tableName}</a>
                                                            <ul class="sidebar-sub-headers">
                                                                <li class="sidebar-sub-header"><a
                                                                            href="#3.${prop_index+1}.2.${table_index+1}.1"
                                                                            class="sidebar-link">3.${prop_index+1}
                                                                        .2.${table_index+1}.1. 表描述</a>
                                                                </li>
                                                                <li class="sidebar-sub-header"><a
                                                                            href="#3.${prop_index+1}.2.${table_index+1}.2"
                                                                            class="sidebar-link">3.${prop_index+1}
                                                                        .2.${table_index+1}.2. 表字段清单</a>
                                                                </li>
                                                            </ul>
                                                        </li>
                                                    </#list>
                                                </ul>
                                            </li>

                                        </ul>
                                    </li>
                                </#list>
                            </ul>
                        </li>

                    </ul>
                </li>
                <li>
                    <ul class="sidebar-group-items">
                        <li><a href="#4" class=" sidebar-link">4. 下载</a>
                        </li>

                    </ul>
                </li>
            </ul>
        </div>
        <div class="page">
            <div class="content">
                <h1 id="1"> 1. 总体概述
                    <button style="float: right;font-size: 1.2rem;" id="open"
                            onclick="window.open(location.href)">窗口打开
                    </button>
                </h1>

                <h2 id="1.1">1.1. 文档描述</h2>
                <div class="tip custom-block">
                    数据库设计文档
                </div>
                <h2 id="1.2">1.2. 阅读对象</h2>
                <div class="tip custom-block">
                    项目经理、技术经理、app开发人员、微信服务号开发人员、后端开发人员等。
                </div>
                <h2 id="1.3">1.3. 名称解释</h2>
                <div class="tip custom-block">
                    <table>
                        <tr>
                            <th width="30%">名词与术语</th>
                            <th width="70%">解释与说明</th>
                        </tr>
                        <tr>
                            <td></td>
                            <td></td>
                        </tr>
                    </table>
                </div>
            </div>
            <div class="content">
                <h1 id="2">2. 数据表清单</h1>
                <div class="tip custom-block">
                    <table>
                        <tr>

                            <th width="20%">所属用户</th>
                            <th width="20%">表名称</th>
                            <th width="60%">表描述</th>
                        </tr>

                        <#list tableUsers?keys as prop>
                            <#list   tableUsers[prop]  as table>
                                <tr>
                                    <td>${table.tableCat}</td>
                                    <td><a  href="#3.${prop_index+1}.2.${table_index+1}"
                                                class="sidebar-link">${table.tableName}</a></td>
                                    <td>${((table.remarks!'')?length>0)?string((table.remarks!''),"<font color='red'>暂无</font>")}</td>
                                </tr>
                            </#list>
                        </#list>
                    </table>
                </div>
            </div>
            <div class="content">
                <h1 id="3"> 3. 数据表定义</h1>
                <#list tableUsers?keys as prop>
                    <h2 id="3.${prop_index+1}">3.${prop_index+1}. ${prop}</h2>
                    <h3 id="3.${prop_index+1}.1">3.${prop_index+1}.1. 用户描述</h3>
                    <div class="tip custom-block">
                        ${prop}
                    </div>
                    <h3 id="3.${prop_index+1}.2">3.${prop_index+1}.2. 数据表列表</h3>
                    <#list   tableUsers[prop]  as table>
                        <h4 id="3.${prop_index+1}.2.${table_index+1}">3.${prop_index+1}.2.${table_index+1}
                            . ${table.tableName}</h4>
                        <h5 id="3.${prop_index+1}.2.${table_index+1}.1">3.${prop_index+1}.2.${table_index+1}.1. 表描述</h5>
                        <div class="tip custom-block">
                            ${((table.remarks!'')?length>0)?string((table.remarks!''),"<font color='red'>暂无</font>")}
                        </div>
                        <h5 id="3.${prop_index+1}.2.${table_index+1}.2">3.${prop_index+1}.2.${table_index+1}.2.
                            表字段清单</h5>
                        <div class="tip custom-block">

                            <table>
                                <tr>
                                    <th>字段名</th>
                                    <th>是否主键</th>
                                    <th>是否可空</th>
                                    <th>是否自增</th>
                                    <th>字段类型</th>
                                    <th>字段长度</th>
                                    <th>字段精度</th>
                                    <th>字段描述</th>
                                </tr>
                                <#list table.columnDtos as column>
                                    <tr>
                                        <td>${column.columnName}</td>
                                        <td>${column.pk?string("是","否")}</td>
                                        <td>${column.nullable?string("是","否")}</td>
                                        <td>${column.autoincrement?string("是","否")}</td>
                                        <td>${column.typeName}</td>
                                        <td>${column.columnSize}</td>
                                        <td>${column.decimalDigits}</td>
                                        <td>${((column.remarks!'')?length>0)?string((column.remarks!''),"<font color='red'>暂无</font>")}</td>
                                    </tr>
                                </#list>
                            </table>
                        </div>
                    </#list>
                </#list>
            </div>
            <div class="content">
                <h1 id="4"> 4. 下载</h1>
                <div class="tip custom-block">
                    <a href="dbOutDocx">下载链接</a>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function addPraiseNum() {
        var praiseObjs = document.getElementsByTagName('a');
        for (let i = 0; i < praiseObjs.length; i++) {
            let praiseObj = praiseObjs[i];
            praiseObj.onclick = function (obj) {
                let className = obj.target.getAttribute("class");
                className = className.replace("active", "")
                var praiseObjs2 = document.getElementsByTagName('a');
                for (let j = 0; j < praiseObjs2.length; j++) {
                    let praiseObj2 = praiseObjs2[j];
                    if (praiseObj2 === obj.target) {
                        praiseObj2.setAttribute("class", className + " active");
                    } else {
                        praiseObj2.setAttribute("class", className);
                    }

                }
            }
        }
    }

    addPraiseNum();
</script>
</body>
</html>