/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.utils.id;

import net.luohuasheng.bee.rest.admin.client.utils.id.IdGenerator;

class SnowflakeIdGenerator
implements IdGenerator {
    private final long workerId;
    private static final long TWEPOCH = 1361753741828L;
    private long sequence = 0L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long SEQUENCE_BITS = 10L;
    private static final long WORKER_ID_SHIFT = 10L;
    private static final long TIMESTAMP_LEFT_SHIFT = 15L;
    private static final long SEQUENCE_MASK = 1023L;
    private long lastTimestamp = -1L;

    @Override
    public long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            try {
                throw new Exception(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastTimestamp = timestamp;
        long nextId = timestamp - 1361753741828L << 15 | this.workerId << 10 | this.sequence;
        return nextId;
    }

    public SnowflakeIdGenerator(long workerId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

