/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class NetworkUtils {
    public static String getHostName() {
        String name = null;
        try {
            Enumeration<NetworkInterface> infs = NetworkInterface.getNetworkInterfaces();
            block2: while (infs.hasMoreElements() && name == null) {
                NetworkInterface net = infs.nextElement();
                if (net.isLoopback()) continue;
                Enumeration<InetAddress> addr = net.getInetAddresses();
                while (addr.hasMoreElements()) {
                    InetAddress inet = addr.nextElement();
                    if (inet.isSiteLocalAddress()) {
                        name = inet.getHostAddress();
                    }
                    if (inet.getCanonicalHostName().equalsIgnoreCase(inet.getHostAddress())) continue;
                    name = inet.getCanonicalHostName();
                    continue block2;
                }
            }
        }
        catch (SocketException e) {
            name = "localhost";
        }
        return name;
    }

    public static String getSiteIp() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface network = interfaces.nextElement();
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!address.isSiteLocalAddress()) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "127.0.0.1";
    }

    public static Integer ip2Num(String ipStr) {
        if (ipStr == null || "".equals(ipStr)) {
            return -1;
        }
        if (ipStr.contains(":")) {
            ipStr = "127.0.0.1";
        }
        String[] ips = ipStr.split("\\.");
        return (Integer.parseInt(ips[0]) << 24) + (Integer.parseInt(ips[1]) << 16) + (Integer.parseInt(ips[2]) << 8) + Integer.parseInt(ips[3]);
    }

    public static String num2Ip(int ipNum) {
        return (ipNum >> 24 & 0xFF) + "." + (ipNum >> 16 & 0xFF) + "." + (ipNum >> 8 & 0xFF) + "." + (ipNum & 0xFF);
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                ipAddress = inet.getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }
}

