/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.luohuasheng.bee.jdbc.tools.component.structure.dto.TableDto;
import net.luohuasheng.bee.rest.admin.client.utils.TemplateTools;
import net.luohuasheng.bee.rest.admin.client.utils.ZipTools;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class Db2Word {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportDoc(List<List<TableDto>> tableDtos, OutputStream out) {
        File outTempFile = null;
        try {
            outTempFile = File.createTempFile("temp", ".xml");
            TemplateTools.createFile(Db2Word.getTableValue(tableDtos), "dbTemplateDoc.ftl", outTempFile.getCanonicalPath());
            ZipInputStream zipInputStream = ZipTools.wrapZipInputStream(Db2Word.class.getClassLoader().getResourceAsStream("template.docx"));
            ZipOutputStream zipOutputStream = ZipTools.wrapZipOutputStream(out);
            String itemname = "word/document.xml";
            ZipTools.replaceItem(zipInputStream, zipOutputStream, itemname, new FileInputStream(new File(outTempFile.getCanonicalPath())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outTempFile != null) {
                outTempFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportHtml(List<List<TableDto>> tableDtos, OutputStream out) {
        File outTempFile = null;
        try {
            outTempFile = File.createTempFile("temp", ".html");
            TemplateTools.createFile(Db2Word.getTableValue(tableDtos), "dbTemplateHtml.ftl", outTempFile.getCanonicalPath());
            FileCopyUtils.copy((InputStream)new FileInputStream(outTempFile), (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outTempFile != null) {
                outTempFile.deleteOnExit();
            }
        }
    }

    private static Map<String, Object> getTableValue(List<List<TableDto>> tableDtos) {
        TreeMap<String, Object> data = new TreeMap<String, Object>();
        TreeMap<String, TreeMap<String, TableDto>> map = new TreeMap<String, TreeMap<String, TableDto>>();
        for (List<TableDto> tableDto : tableDtos) {
            for (TableDto dto : tableDto) {
                String user = StringUtils.isEmpty((Object)dto.getTableCat()) ? dto.getTableSchem() : dto.getTableCat();
                String tableName = dto.getTableName();
                TreeMap<String, TableDto> userMap = (TreeMap<String, TableDto>)map.get(user);
                if (userMap == null) {
                    userMap = new TreeMap<String, TableDto>();
                    map.put(user, userMap);
                    userMap.put(tableName, dto);
                    continue;
                }
                userMap.putIfAbsent(tableName, dto);
            }
        }
        HashMap users = new HashMap();
        for (Map.Entry stringMapEntry : map.entrySet()) {
            users.put(stringMapEntry.getKey(), new ArrayList(((Map)map.get(stringMapEntry.getKey())).values()));
        }
        data.put("tableUsers", users);
        return data;
    }
}

