/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.interceptor;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.luohuasheng.bee.rest.admin.client.aop.DynamicAdvice;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Intercepts(value={@Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(method="update", type=Executor.class, args={MappedStatement.class, Object.class})})
public class SqlInterceptor
implements Interceptor {
    private static final Map<String, Method> METHOD_MAP = new ConcurrentHashMap<String, Method>();
    private static final Map<String, Class> CLASS_MAP = new ConcurrentHashMap<String, Class>();
    private Logger logger = LoggerFactory.getLogger(SqlInterceptor.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DynamicAdvice dynamicAdvice;

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        this.addSqlMethod(mappedStatement.getId(), DynamicAdvice.CallType.before);
        Object value = null;
        try {
            value = invocation.proceed();
        }
        catch (Exception e) {
            this.addSqlMethod(mappedStatement.getId(), DynamicAdvice.CallType.exception);
            throw e;
        }
        this.addSqlMethod(mappedStatement.getId(), DynamicAdvice.CallType.after);
        return value;
    }

    private void addSqlMethod(String id, DynamicAdvice.CallType type) throws ClassNotFoundException {
        if (this.dynamicAdvice == null) {
            this.dynamicAdvice = (DynamicAdvice)this.applicationContext.getBean(DynamicAdvice.class);
        }
        Method method = this.getMethod(id);
        if (DynamicAdvice.CallType.before.equals((Object)type)) {
            this.dynamicAdvice.beforeValue(CLASS_MAP.get(id), method, true);
        } else {
            this.dynamicAdvice.returnValue(CLASS_MAP.get(id), method, type);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Method getMethod(String id) throws ClassNotFoundException {
        Method method = METHOD_MAP.get(id);
        if (method == null) {
            int index = id.lastIndexOf(".");
            String className = id.substring(0, index);
            String methodName = id.substring(index + 1);
            Class<?> classZ = Class.forName(className);
            for (Method method2 : classZ.getMethods()) {
                if (!method2.getName().equals(methodName)) continue;
                METHOD_MAP.put(id, method2);
                CLASS_MAP.put(id, classZ);
                return method2;
            }
        } else {
            return method;
        }
        throw new RuntimeException("not fond method");
    }
}

