/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.luohuasheng.bee.rest.admin.client.config.ClientProperties;
import net.luohuasheng.bee.rest.admin.client.dto.system.ActuatorUserDto;
import net.luohuasheng.bee.rest.admin.client.endpoint.SignEndPoint;
import net.luohuasheng.bee.rest.admin.client.utils.CookieUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

@Component
public class AdminSecurityFilter
implements Filter {
    private final ClientProperties clientProperties;
    @Autowired
    private SignEndPoint signEndPoint;
    private static Map<String, ActuatorUserDto> LOGIN_CACHE_MAP = new HashMap<String, ActuatorUserDto>();
    private static Integer expire = 7200;
    private static final String CACHE_POOL_KEY = "cache-schedule-pool-%d";
    private static final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("cache-schedule-pool-%d").daemon(true).build());

    public AdminSecurityFilter(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)arg0;
        HttpServletResponse response = (HttpServletResponse)arg1;
        if (this.needLogin(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    private boolean needLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isOk;
        String consoleToken = CookieUtils.getCookie("ConsoleToken");
        boolean bl = isOk = request.getRequestURI().endsWith("actuator/sign") || request.getRequestURI().contains("/admin-ui") || request.getRequestURI().contains(this.clientProperties.getName()) || !StringUtils.isEmpty((CharSequence)consoleToken) && this.signEndPoint.verify(consoleToken, request);
        if (isOk) {
            request.setAttribute("isConsole", (Object)true);
            return true;
        }
        ActuatorUserDto actuatorUser = this.getActuatorUser();
        boolean bl2 = isOk = request.getRequestURI().endsWith("login") || request.getRequestURI().endsWith("logout");
        if (isOk) {
            return true;
        }
        if (actuatorUser == null) {
            response.setStatus(HttpStatus.FORBIDDEN.value());
            response.setContentType("application/json");
            response.getWriter().println("{}");
            return false;
        }
        return true;
    }

    public ActuatorUserDto get() {
        String key = CookieUtils.getCookie("ActuatorUser");
        return LOGIN_CACHE_MAP.get(key);
    }

    public void remove() {
        String key = CookieUtils.getCookie("ActuatorUser");
        LOGIN_CACHE_MAP.remove(key);
        CookieUtils.removeCookie(key);
    }

    public ActuatorUserDto add(ActuatorUserDto actuatorUserDto) {
        String key = this.buildKey(actuatorUserDto);
        CookieUtils.addCookie("ActuatorUser", key, expire);
        return LOGIN_CACHE_MAP.put(key, actuatorUserDto);
    }

    private String buildKey(ActuatorUserDto actuatorUserDto) {
        return DigestUtils.md5DigestAsHex((byte[])this.objectToByte(actuatorUserDto));
    }

    private byte[] objectToByte(Object obj) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            bytes = bo.toByteArray();
            bo.close();
            oo.close();
        }
        catch (Exception e) {
            System.out.println("translation" + e.getMessage());
            e.printStackTrace();
        }
        return bytes;
    }

    @PostConstruct
    public void init() {
        expire = this.clientProperties.getExpire();
    }

    private ActuatorUserDto getActuatorUser() {
        ActuatorUserDto actuatorUserDto = this.get();
        if (actuatorUserDto == null) {
            return null;
        }
        if (actuatorUserDto.getLastLoginTime().before(DateUtils.addSeconds((Date)new Date(), (int)(-expire.intValue())))) {
            return null;
        }
        actuatorUserDto.setLastLoginTime(new Date());
        return actuatorUserDto;
    }

    static {
        executorService.scheduleAtFixedRate(() -> {
            HashSet<String> expiredKeys = new HashSet<String>();
            for (Map.Entry<String, ActuatorUserDto> stringActuatorUserDtoEntry : LOGIN_CACHE_MAP.entrySet()) {
                if (!stringActuatorUserDtoEntry.getValue().getLastLoginTime().before(DateUtils.addSeconds((Date)new Date(), (int)(-expire.intValue())))) continue;
                expiredKeys.add(stringActuatorUserDtoEntry.getKey());
            }
            for (String expiredKey : expiredKeys) {
                LOGIN_CACHE_MAP.remove(expiredKey);
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }
}

