/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.endpoint;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.luohuasheng.bee.rest.admin.client.config.ClientProperties;
import net.luohuasheng.bee.rest.admin.client.dto.system.ActuatorRsetPwdDto;
import net.luohuasheng.bee.rest.admin.client.dto.system.ActuatorUserDto;
import net.luohuasheng.bee.rest.admin.client.interceptor.AdminSecurityFilter;
import net.luohuasheng.bee.rest.admin.client.utils.RequestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@RestControllerEndpoint(id="system")
public class SystemEndPoint {
    private final ClientProperties clientProperties;
    private static final String UNKNOWN = "unknown";
    private final AdminSecurityFilter adminSecurityFilter;

    public SystemEndPoint(ClientProperties clientProperties, AdminSecurityFilter adminSecurityFilter) {
        this.clientProperties = clientProperties;
        this.adminSecurityFilter = adminSecurityFilter;
    }

    @GetMapping(value={"logout"})
    public Object logout(HttpServletResponse response) {
        this.adminSecurityFilter.remove();
        return RequestUtils.ok(response);
    }

    @PostMapping(value={"rsetPwd"})
    public Object rsetPwd(@RequestBody ActuatorRsetPwdDto actuatorRsetPwdDto, HttpServletRequest request, HttpServletResponse response) {
        Boolean isConsole = (Boolean)request.getAttribute("isConsole");
        if (!BooleanUtils.isTrue((Boolean)isConsole) && !this.clientProperties.getUsername().equals(actuatorRsetPwdDto.getPwdOld())) {
            return this.securityException("\u9519\u8bef\u7684\u5bc6\u7801", response);
        }
        if (StringUtils.isEmpty((CharSequence)actuatorRsetPwdDto.getPwdNew())) {
            return this.securityException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", response);
        }
        this.clientProperties.setUsername(actuatorRsetPwdDto.getUserName());
        this.clientProperties.setPassword(actuatorRsetPwdDto.getPwdNew());
        return RequestUtils.ok(response);
    }

    @RequestMapping(value={"login"}, method={RequestMethod.GET, RequestMethod.POST})
    public Object login(@RequestParam String userName, @RequestParam String password, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)userName) || StringUtils.isEmpty((CharSequence)password)) {
            return this.securityException("\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", response);
        }
        if (!this.clientProperties.getUsername().equals(userName) || !this.clientProperties.getPassword().equals(password)) {
            return this.securityException("\u9519\u8bef\u7684\u7528\u6237\u540d\u6216\u5bc6\u7801", response);
        }
        ActuatorUserDto actuatorUserDto = new ActuatorUserDto();
        actuatorUserDto.setUserName(userName);
        actuatorUserDto.setLastLoginTime(new Date());
        this.adminSecurityFilter.add(actuatorUserDto);
        return RequestUtils.ok(response);
    }

    private Map<String, String> securityException(String message, HttpServletResponse response) {
        response.setContentType("application/json");
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("message", message);
        return map;
    }

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

