/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.endpoint;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.PostConstruct;
import net.luohuasheng.bee.rest.admin.client.dto.jar.JarDto;
import net.luohuasheng.bee.rest.admin.client.dto.jar.ValueDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.ApplicationDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.ComputerSystemDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.CpuDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.DiskStoreDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.FileSystemDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.JvmMemDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.MemoryDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.NetworkDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.ProcessDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.ProcessorDto;
import net.luohuasheng.bee.rest.admin.client.dto.monitor.VersionDto;
import net.luohuasheng.bee.rest.admin.client.utils.DateDistanceUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import oshi.software.os.OperatingSystem;

@Component
@RestControllerEndpoint(id="monitor")
public class MonitorEndPoint {
    @Value(value="${management.admin.PathMatchers:}")
    private List<String> jarPathMatcher;
    private ApplicationDto applicationDto;
    private AtomicInteger activeHttpSessions = new AtomicInteger(0);
    private Date startTime;
    @Autowired
    private HealthEndpoint healthEndpoint;
    @Autowired
    private StandardEnvironment environment;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public AtomicInteger getActiveHttpSessions() {
        return this.activeHttpSessions;
    }

    @GetMapping(value={"{name}"})
    public Object invoke(@PathVariable(value="name") String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        String[] names = name.split(",");
        if (names.length == 1) {
            try {
                return this.invoke(MonitorType.valueOf(name));
            }
            catch (Exception e) {
                return null;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        for (String name2 : names) {
            try {
                MonitorType monitorType = MonitorType.valueOf(name2);
                map.put(monitorType.name(), this.invoke(monitorType));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    @GetMapping(value={"/process/{id}"})
    public Object process(@PathVariable(value="id") String pid) {
        ProcessDto dto = ProcessDto.getProcesseDto(pid);
        return dto == null ? new ProcessDto() : dto;
    }

    Object invoke(MonitorType monitorType) {
        switch (monitorType) {
            case cpu: {
                return new CpuDto();
            }
            case jvmMem: {
                return new JvmMemDto();
            }
            case memory: {
                return new MemoryDto();
            }
            case network: {
                return NetworkDto.createNetDtos();
            }
            case version: {
                return VersionDto.getInstance();
            }
            case processe: {
                return ProcessDto.createProcesseDto(OperatingSystem.ProcessSort.CPU, 5);
            }
            case diskStore: {
                return DiskStoreDto.createDiskStores();
            }
            case processor: {
                return new ProcessorDto();
            }
            case fileSystem: {
                return FileSystemDto.createFileSystems();
            }
            case application: {
                return this.application();
            }
            case computerSystem: {
                return new ComputerSystemDto();
            }
        }
        return null;
    }

    private ApplicationDto application() {
        if (this.applicationDto == null) {
            this.startTime = new Date();
            this.applicationDto = new ApplicationDto();
            this.applicationDto.setPid(this.environment.getProperty("PID"));
            this.applicationDto.setJavaVendor(this.environment.getProperty("java.vendor"));
            this.applicationDto.setJavaVersion(this.environment.getProperty("java.version"));
            this.applicationDto.setJavaName(this.environment.getProperty("java.runtime.name"));
            this.applicationDto.setOsArch(this.environment.getProperty("os.arch"));
            this.applicationDto.setOsName(this.environment.getProperty("os.name"));
            this.applicationDto.setOsVersion(this.environment.getProperty("os.version"));
            this.applicationDto.setUserCountry(this.environment.getProperty("user.country"));
            this.applicationDto.setUserTimezone(this.environment.getProperty("user.timezone"));
            this.applicationDto.setProfiles(this.environment.getProperty("spring.profiles.active", "dev"));
            this.applicationDto.setName(this.environment.getProperty("spring.application.name"));
            this.applicationDto.setVersion(this.environment.getProperty("git.build.version"));
        }
        this.applicationDto.setSystemUptime(DateDistanceUtils.getDistanceTime(new Date(), this.startTime));
        this.applicationDto.setStatus(this.healthEndpoint.health().getStatus().getCode());
        this.applicationDto.setActiveHttpSessions(this.activeHttpSessions.get());
        return this.applicationDto;
    }

    @PostConstruct
    public void init() {
        this.activeHttpSessions = new AtomicInteger(0);
        TreeMap<String, JarDto> jarDtoMap = new TreeMap<String, JarDto>();
        try {
            Resource[] source;
            Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            PathMatchingResourcePatternResolver resourceLoader = new PathMatchingResourcePatternResolver();
            for (Resource resource : source = resourceLoader.getResources("classpath*:/META-INF/**/pom.properties")) {
                this.loadProperties(resource.getURL(), jarDtoMap, "=");
            }
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                this.loadProperties(url, jarDtoMap, ": ");
            }
            ResourcePropertySource jarPropertySource = new ResourcePropertySource("java.class.path", "classpath:empty.properties");
            this.environment.getPropertySources().addLast((PropertySource)jarPropertySource);
            for (Map.Entry stringJarDtoEntry : jarDtoMap.entrySet()) {
                ResourcePropertySource propertySource = new ResourcePropertySource(((JarDto)stringJarDtoEntry.getValue()).getJarName(), "classpath:empty.properties");
                for (ValueDto property : ((JarDto)stringJarDtoEntry.getValue()).getProperties()) {
                    ((Map)propertySource.getSource()).put(property.getKey(), property.getValue());
                }
                ((Map)jarPropertySource.getSource()).put(((JarDto)stringJarDtoEntry.getValue()).getJarName(), "\u3010" + DateFormatUtils.format((long)Long.parseLong(((Map)propertySource.getSource()).getOrDefault("lastModifiedTime", "0")), (String)"yyyy-MM-dd HH:mm:ss") + "\u3011" + ((Map)propertySource.getSource()).getOrDefault("Created-By", "") + " " + ((Map)propertySource.getSource()).getOrDefault("Build-Jdk", ""));
                if (!this.checkJarName(((JarDto)stringJarDtoEntry.getValue()).getJarName())) continue;
                this.environment.getPropertySources().addLast((PropertySource)propertySource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean checkJarName(String jarName) {
        for (String jarPrefix : this.jarPathMatcher) {
            if (!this.pathMatcher.match(jarPrefix, jarName)) continue;
            return true;
        }
        return false;
    }

    private void loadProperties(URL url, Map<String, JarDto> jarDtoMap, String splitTag) {
        try {
            String uri = url.getFile();
            uri = uri.substring(0, uri.lastIndexOf("!"));
            Long lastModifiedTime = this.lastModifiedTime(uri.replace("file:", ""));
            uri = uri.substring(uri.lastIndexOf("/") + 1);
            JarDto jarDto = jarDtoMap.get(uri);
            if (jarDto == null) {
                jarDto = new JarDto();
                jarDto.setJarName(uri);
                ArrayList<ValueDto> properties = new ArrayList<ValueDto>();
                ValueDto dto = new ValueDto();
                dto.setKey("lastModifiedTime");
                dto.setValue(lastModifiedTime.toString());
                properties.add(dto);
                jarDto.setProperties(properties);
                InputStream is = url.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                this.loadProperties(br, splitTag, properties);
                jarDtoMap.put(uri, jarDto);
            } else {
                jarDto.setJarName(uri);
                InputStream is = url.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                this.loadProperties(br, splitTag, jarDto.getProperties());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Long lastModifiedTime(String filePath) {
        if (!filePath.contains("!")) {
            File file = new File(filePath);
            try {
                Path path = Paths.get(filePath, new String[0]);
                BasicFileAttributeView basicview = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                BasicFileAttributes attr = basicview.readAttributes();
                return attr.creationTime().toMillis();
            }
            catch (Exception e) {
                return file.lastModified();
            }
        }
        if (filePath.split("!").length == 2) {
            String[] filePaths = filePath.split("!");
            try {
                JarFile file = new JarFile(filePaths[0]);
                Enumeration<JarEntry> enu = file.entries();
                while (enu.hasMoreElements()) {
                    JarEntry element = enu.nextElement();
                    String name = element.getName();
                    if (!filePaths[1].endsWith(name)) continue;
                    return element.getTime();
                }
            }
            catch (IOException e) {
                return 0L;
            }
        } else {
            return 0L;
        }
        return 0L;
    }

    private void loadProperties(BufferedReader br, String splitTag, List<ValueDto> properties) throws IOException {
        if ("=".equals(splitTag)) {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] lines = line.split(splitTag);
                ValueDto valueDto = new ValueDto();
                valueDto.setKey(lines[0]);
                valueDto.setValue(lines[1]);
                properties.add(valueDto);
            }
        } else {
            String line;
            ValueDto valueDto = null;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)line)) continue;
                if (line.contains(splitTag)) {
                    boolean isOk;
                    boolean bl = isOk = valueDto != null && ("Export-Package".equals(valueDto.getKey()) || "Import-Package".equals(valueDto.getKey()) || "Include-Resource".equals(valueDto.getKey()));
                    if (isOk) {
                        properties.remove(valueDto);
                    }
                    String[] lines = line.split(splitTag);
                    valueDto = new ValueDto();
                    valueDto.setKey(lines[0]);
                    if (lines.length == 1) {
                        valueDto.setValue("");
                    } else {
                        valueDto.setValue(lines[1]);
                    }
                    properties.add(valueDto);
                    continue;
                }
                valueDto.setValue(Objects.requireNonNull(valueDto).getValue() + line);
            }
        }
    }

    public static enum MonitorType {
        computerSystem,
        cpu,
        fileSystem,
        diskStore,
        jvmMem,
        memory,
        network,
        processor,
        version,
        application,
        processe;

    }
}

