/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.endpoint;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.Status;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import net.luohuasheng.bee.rest.admin.client.dto.log.FileDto;
import net.luohuasheng.bee.rest.admin.client.dto.log.FileReadDto;
import net.luohuasheng.bee.rest.admin.client.dto.log.LoggerDto;
import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@RestControllerEndpoint(id="logback")
public class LogbackEndPoint {
    private static final String ROOT = "root";
    private static final Integer BIT = 1024;
    @Value(value="${LOG_HOME:-.}")
    private String logHome;
    private String managerDir;
    @Value(value="${management.logback.maxSize:100}")
    private Integer maxSize = 100;
    @Autowired(required=false)
    private HttpServletResponse response;

    @PostConstruct
    public void init() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.managerDir = "";
        for (Status status : loggerContext.getStatusManager().getCopyOfStatusList()) {
            TimeBasedRollingPolicy policy;
            if (!(status.getOrigin() instanceof TimeBasedRollingPolicy) || !(policy = (TimeBasedRollingPolicy)status.getOrigin()).getActiveFileName().contains("/")) continue;
            this.managerDir = policy.getActiveFileName().substring(0, policy.getActiveFileName().lastIndexOf("/"));
        }
    }

    @GetMapping(value={"/"})
    public List<LoggerDto> call() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ArrayList<LoggerDto> loggerDtos = new ArrayList<LoggerDto>();
        List loggers = loggerContext.getLoggerList();
        for (Logger logger : loggers) {
            loggerDtos.add(this.conventLogger(logger));
        }
        return loggerDtos;
    }

    @PostMapping(value={"/{level}"})
    public String level(@PathVariable(value="level") String level, @RequestParam String packages) {
        try {
            packages = URLDecoder.decode(packages, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        List loggers = loggerContext.getLoggerList();
        for (Logger logger : loggers) {
            if (!ROOT.equalsIgnoreCase(packages) && !logger.getName().startsWith(packages)) continue;
            logger.setLevel(Level.toLevel((String)level));
        }
        if (ROOT.equalsIgnoreCase(packages)) {
            return "{'message':'\u5168\u5c40\u65e5\u5fd7\u7ea7\u522b\u4fee\u6539\u4e3a[" + level + "]}'";
        }
        return "'message':'\u5305\u540d[" + packages + "]\u65e5\u5fd7\u7ea7\u522b\u4fee\u6539\u4e3a[" + level + "]'";
    }

    @PostMapping(value={"/filter"})
    public List<LoggerDto> filter(@RequestParam Integer packageLevel, @RequestParam String packages) {
        if (packageLevel == 0) {
            packageLevel = 999;
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        List loggers = loggerContext.getLoggerList();
        ArrayList<LoggerDto> loggerDtos = new ArrayList<LoggerDto>();
        for (Logger logger : loggers) {
            boolean isOk = StringUtils.isEmpty((CharSequence)packages) || logger.getName().equals(packages) || logger.getName().startsWith(packages) && logger.getName().split("\\.").length < packageLevel + 1;
            if (!isOk) continue;
            loggerDtos.add(this.conventLogger(logger));
        }
        return loggerDtos;
    }

    @PostMapping(value={"/loadFile"})
    public FileReadDto loadFile(@RequestParam String dir, @RequestParam String fileName, @RequestParam Long fileId, @RequestParam(required=false, defaultValue="0") Long range) {
        File file = this.getFile(dir, fileName);
        try {
            FileReadDto fileReadDto = new FileReadDto();
            fileReadDto.setFileId(fileId);
            fileReadDto.setSize(file.length());
            StringBuffer sb = new StringBuffer();
            FileReader reader = new FileReader(file);
            BufferedReader br = new BufferedReader(reader);
            br.skip(range);
            String str = null;
            Integer bytesRead = 0;
            while ((str = br.readLine()) != null && (bytesRead = Integer.valueOf(bytesRead + (str.getBytes().length + 1))) <= this.maxSize * 1024) {
                sb.append(str).append("\r\n");
            }
            fileReadDto.setText(sb.toString());
            if (sb.length() == 0) {
                fileReadDto.setRange(file.length());
            } else {
                fileReadDto.setRange(range + (long)bytesRead.intValue());
            }
            br.close();
            reader.close();
            return fileReadDto;
        }
        catch (IOException e) {
            return null;
        }
    }

    @PostMapping(value={"/tailFile"})
    public FileReadDto tailFile(@RequestParam String dir, @RequestParam String fileName, @RequestParam Long fileId, @RequestParam(required=false, defaultValue="0") Long range) {
        if (range == 0L) {
            File file = this.getFile(dir, fileName);
            try {
                FileReader reader = new FileReader(file);
                BufferedReader br = new BufferedReader(reader);
                FileReadDto fileReadDto = new FileReadDto();
                fileReadDto.setFileId(fileId);
                fileReadDto.setSize(file.length());
                fileReadDto.setRange(file.length());
                StringBuffer sb = new StringBuffer();
                if (file.length() > (long)(this.maxSize * BIT)) {
                    br.skip(file.length() - (long)(this.maxSize * BIT));
                }
                String str = null;
                br.readLine();
                while ((str = br.readLine()) != null) {
                    sb.append(str).append("\r\n");
                }
                fileReadDto.setText(sb.toString());
                br.close();
                reader.close();
                return fileReadDto;
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.loadFile(dir, fileName, fileId, range);
    }

    @GetMapping(value={"/downloadFile"})
    public void downloadFile(@RequestParam String dir, @RequestParam String fileName) {
        File file = this.getFile(dir, fileName);
        if (file.length() > 0L) {
            try {
                this.response.setContentLength((int)file.length());
                this.response.setHeader("content-type", "application/octet-stream");
                this.response.setHeader("content-disposition", "attachment;filename*=utf-8''" + URLEncoder.encode(fileName, "UTF-8"));
                StreamUtils.copy((InputStream)new FileInputStream(file), (OutputStream)this.response.getOutputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @PostMapping(value={"/list"})
    private List<FileDto> list(@RequestParam String dir) {
        ArrayList<FileDto> fileDtos = new ArrayList<FileDto>();
        dir = !StringUtils.isEmpty((CharSequence)this.managerDir) ? this.managerDir + dir : this.logHome.replace("-.", ".") + "/logs" + dir;
        File file = new File(dir);
        if (file.exists()) {
            for (File listFile : file.listFiles()) {
                if (!listFile.canRead() || listFile.isHidden()) continue;
                FileDto fileDto = new FileDto();
                fileDto.setDirectory(listFile.isDirectory());
                fileDto.setFileName(listFile.getName());
                fileDto.setLastModified(listFile.lastModified());
                fileDto.setLength(listFile.length());
                if (listFile.isFile()) {
                    fileDto.setFileType(listFile.getName().substring(listFile.getName().lastIndexOf(".") + 1));
                } else {
                    fileDto.setFileType("");
                }
                fileDtos.add(fileDto);
            }
        }
        fileDtos.sort((o2, o1) -> o1.getLastModified().compareTo(o2.getLastModified()));
        return fileDtos;
    }

    @GetMapping(value={"/getCssFile"})
    public Set<String> getCssFile() {
        HashSet<String> baseanmeSet = new HashSet<String>();
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = pathMatchingResourcePatternResolver.getResources("classpath:page/static/styles/*.css");
            for (int i = 0; i < resources.length; ++i) {
                Resource resource = resources[i];
                String filePath = resource.getFilename();
                baseanmeSet.add(filePath.substring(0, filePath.indexOf(".")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baseanmeSet;
    }

    private File getFile(String dir, String fileName) {
        dir = !StringUtils.isEmpty((CharSequence)this.managerDir) ? this.managerDir + dir : this.logHome.replace("-.", ".") + "/logs" + dir;
        File file = new File(dir + fileName);
        return file;
    }

    private LoggerDto conventLogger(Logger logger) {
        LoggerDto loggerDto = new LoggerDto();
        loggerDto.setName(logger.getName());
        if (logger.getLevel() != null) {
            loggerDto.setLevel(logger.getLevel().levelStr);
        } else {
            loggerDto.setLevel(this.getParentLevel((Logger)logger).levelStr);
        }
        return loggerDto;
    }

    private Level getParentLevel(Logger logger) {
        Logger parent = (Logger)FieldUtils.getFieldValue("parent", logger);
        Level level = parent.getLevel();
        if (level == null) {
            return this.getParentLevel(parent);
        }
        return level;
    }
}

