/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.endpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
@RestControllerEndpoint(id="env2")
public class EnvEndPoint {
    @Autowired
    private StandardEnvironment environment;

    @RequestMapping(method={RequestMethod.GET}, value={"/info"})
    public Object info() {
        TreeSet<String> keys = new TreeSet<String>();
        for (PropertySource propertySource : this.environment.getPropertySources()) {
            if ("java.class.path".equals(propertySource.getName())) continue;
            if (propertySource.getSource() instanceof Map) {
                keys.addAll(((Map)propertySource.getSource()).keySet());
                continue;
            }
            if (!(propertySource.getSource() instanceof Properties)) continue;
            Properties properties = (Properties)propertySource.getSource();
            keys.addAll(properties.stringPropertyNames());
        }
        return this.loadInfo(keys);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/info/{name:.*}"})
    public Object info2(@PathVariable String name) {
        TreeSet<String> keys = new TreeSet<String>();
        for (PropertySource propertySource : this.environment.getPropertySources()) {
            if ("java.class.path".equals(propertySource.getName())) continue;
            if (propertySource.getSource() instanceof Map) {
                keys.addAll(((Map)propertySource.getSource()).keySet().stream().filter(key -> key.contains(name)).collect(Collectors.toList()));
                continue;
            }
            if (!(propertySource.getSource() instanceof Properties)) continue;
            Properties properties = (Properties)propertySource.getSource();
            keys.addAll(properties.stringPropertyNames().stream().filter(key -> key.contains(name)).collect(Collectors.toList()));
        }
        return this.loadInfo(keys);
    }

    private Map<String, Object> loadInfo(Set<String> keys) {
        TreeMap<String, Object> objectMap = new TreeMap<String, Object>();
        for (String key : keys) {
            if (!key.contains(".") || key.contains("class.path") || key.endsWith(".jar")) continue;
            String value = this.environment.getProperty(key);
            if (key.toLowerCase().contains("key") || key.toLowerCase().contains("password") || key.toLowerCase().contains("pwd")) {
                value = "******";
            }
            System.out.println(key);
            String[] names = key.split("\\.");
            Map<String, Object> map = null;
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (map == null) {
                    map = (HashMap<String, Object>)objectMap.get(name);
                    if (map != null) continue;
                    map = new HashMap<String, Object>();
                    objectMap.put(name, map);
                    continue;
                }
                if (i == names.length - 1) {
                    map.put(name, value);
                    continue;
                }
                Object map2 = map.computeIfAbsent(name, k -> new HashMap());
                if (!(map2 instanceof Map)) continue;
                map = (Map)map2;
            }
        }
        return objectMap;
    }
}

