/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.endpoint;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.luohuasheng.bee.rest.admin.client.components.DataSourceComponent;
import net.luohuasheng.bee.rest.admin.client.utils.Db2Word;
import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.GetMapping;

@Component
@RestControllerEndpoint(id="doc")
public class DocEndPoint {
    @Autowired(required=false)
    private HttpServletResponse response;
    @Autowired
    private HttpServletRequest request;
    @Autowired(required=false)
    private DataSourceComponent dataSourceComponent;
    @Autowired
    private ApplicationContext applicationContext;

    @GetMapping(value={"/dbOutDocx"})
    public Object dbOutDocx() throws IOException, SQLException, ExecutionException, InterruptedException {
        this.response.setHeader("Content-Disposition", "attachment; filename=\"db.docx\"");
        this.response.setContentType("application/octet-stream;charset=UTF-8");
        Db2Word.exportDoc(this.dataSourceComponent == null ? Collections.emptyList() : this.dataSourceComponent.getTables(), (OutputStream)this.response.getOutputStream());
        return null;
    }

    @GetMapping(value={"/dbOutHtml"})
    public Object dbOutHtml() throws IOException, SQLException, ExecutionException, InterruptedException {
        Db2Word.exportHtml(this.dataSourceComponent == null ? Collections.emptyList() : this.dataSourceComponent.getTables(), (OutputStream)this.response.getOutputStream());
        return null;
    }

    private Map<String, String> loadMessage() {
        TreeMap<String, String> value = new TreeMap<String, String>();
        Map messageSources = this.applicationContext.getBeansOfType(MessageSource.class);
        for (MessageSource messageSource : messageSources.values()) {
            if (messageSource instanceof ResourceBundleMessageSource) {
                for (String basename : ((ResourceBundleMessageSource)messageSource).getBasenameSet()) {
                    try {
                        Method method = ReflectionUtils.findMethod(ResourceBundleMessageSource.class, (String)"getResourceBundle", (Class[])new Class[]{String.class, Locale.class});
                        method.setAccessible(true);
                        ResourceBundle resourceBundle = (ResourceBundle)method.invoke((Object)messageSource, basename, LocaleContextHolder.getLocale());
                        method.setAccessible(false);
                        for (String key : resourceBundle.keySet()) {
                            value.put(key, resourceBundle.getString(key));
                        }
                    }
                    catch (Exception method) {
                    }
                }
                continue;
            }
            if (!(messageSource instanceof ReloadableResourceBundleMessageSource)) continue;
            try {
                Method method = ReflectionUtils.findMethod(ReloadableResourceBundleMessageSource.class, (String)"getMergedProperties", (Class[])new Class[]{Locale.class});
                method.setAccessible(true);
                Object object = method.invoke((Object)messageSource, LocaleContextHolder.getLocale());
                method.setAccessible(false);
                Properties properties = (Properties)FieldUtils.getFieldValue(object, "properties");
                if (properties == null) continue;
                for (String key : properties.stringPropertyNames()) {
                    value.put(key, properties.getProperty(key));
                }
            }
            catch (Exception exception) {
            }
        }
        return value;
    }
}

