/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.endpoint;

import io.micrometer.core.instrument.LocalMeterRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.luohuasheng.bee.rest.admin.client.aop.DynamicAdvice;
import net.luohuasheng.bee.rest.admin.client.aop.DynamicPointcut;
import net.luohuasheng.bee.rest.admin.client.dto.application.MethodMonitorTimeDto;
import net.luohuasheng.bee.rest.admin.client.dto.application.MethodTimeDto;
import net.luohuasheng.bee.rest.admin.client.dto.application.MonitorMethodTimeDto;
import net.luohuasheng.bee.rest.admin.client.dto.application.ResponseMethodTimeDto;
import net.luohuasheng.bee.rest.admin.client.dto.application.ResponseStatusDto;
import net.luohuasheng.bee.rest.admin.client.dto.application.ResponseTimeDto;
import net.luohuasheng.bee.rest.admin.client.utils.ConstantUtils;
import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
@RestControllerEndpoint(id="application")
public class ApplicationEndPoint {
    private static final Map<String, MonitorMethodTimeDto> LOGIN_CACHE_MAP = new HashMap<String, MonitorMethodTimeDto>();
    private static final Set<String> REGISTRY_URIS = new TreeSet<String>();
    private static final Integer EXPIRE = 600;
    private static final String CACHE_POOL_KEY = "cache-schedule-pool-%d";
    private static final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("cache-schedule-pool-%d").daemon(true).build());
    @Autowired
    private LocalMeterRegistry localMeterRegistry;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DynamicPointcut dynamicPointcut;
    private boolean isInit = false;

    public void init() {
        ArrayList servletRegistrationBeans = new ArrayList(this.applicationContext.getBeansOfType(ServletRegistrationBean.class).values());
        ArrayList requestMappingHandlerMappings = new ArrayList(this.applicationContext.getBeansOfType(RequestMappingHandlerMapping.class).values());
        for (RequestMappingHandlerMapping requestMappingHandlerMapping : requestMappingHandlerMappings) {
            for (Map.Entry requestMappingInfoHandlerMethodEntry : requestMappingHandlerMapping.getHandlerMethods().entrySet()) {
                Method method = ((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getMethod();
                if (this.dynamicPointcut.checkRequestPackages(method.getDeclaringClass())) {
                    ConstantUtils.MONITOR_CLASSS.add(method.getDeclaringClass().getCanonicalName() + "." + method.getName());
                }
                REGISTRY_URIS.addAll(((RequestMappingInfo)requestMappingInfoHandlerMethodEntry.getKey()).getPatternsCondition().getPatterns());
            }
        }
        for (ServletRegistrationBean servletRegistrationBean : servletRegistrationBeans) {
            REGISTRY_URIS.addAll(servletRegistrationBean.getUrlMappings());
        }
        this.isInit = true;
    }

    @PostMapping(value={"/methodClassName/{classPath}"})
    public Object methodClassName(@PathVariable(value="classPath") String classPath, @RequestParam String classMethods, @RequestParam String classMethod) {
        if (!StringUtils.isEmpty((Object)classMethod)) {
            LOGIN_CACHE_MAP.remove(classMethod);
        }
        if (!StringUtils.isEmpty((Object)classMethods)) {
            for (String className : classMethods.split(",")) {
                MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(className);
                if (monitorMethodTimeDto != null) continue;
                monitorMethodTimeDto = new MonitorMethodTimeDto();
                monitorMethodTimeDto.setFullClassName(className);
                monitorMethodTimeDto.setLastTime(new Date());
                LOGIN_CACHE_MAP.put(className, monitorMethodTimeDto);
            }
        }
        return "ok";
    }

    @GetMapping(value={"/methodClassNameDetail/{classMethod}"})
    public List<ResponseMethodTimeDto> methodClassNameDetail(@PathVariable(value="classMethod") String classMethod) {
        MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(classMethod);
        if (monitorMethodTimeDto == null) {
            return new ArrayList<ResponseMethodTimeDto>();
        }
        ArrayList<ResponseMethodTimeDto> responseMethodTimeDtos = new ArrayList<ResponseMethodTimeDto>();
        ArrayList<List<MethodTimeDto>> all = new ArrayList<List<MethodTimeDto>>(monitorMethodTimeDto.getQueue().getAll());
        for (List list : all) {
            ResponseMethodTimeDto responseMethodTimeDto = new ResponseMethodTimeDto();
            responseMethodTimeDto.setClassName(((MethodTimeDto)list.get(0)).getClassZ().getCanonicalName());
            responseMethodTimeDto.setMethodName(((MethodTimeDto)list.get(0)).getMethod().getName());
            responseMethodTimeDto.setLevelType(((MethodTimeDto)list.get(0)).getLevel());
            responseMethodTimeDto.setRequestTime(new Date(((MethodTimeDto)list.get(0)).getTimestamp()));
            responseMethodTimeDto.setTime(((MethodTimeDto)list.get(list.size() - 1)).getTimestamp() - ((MethodTimeDto)list.get(0)).getTimestamp());
            responseMethodTimeDto.setType(((MethodTimeDto)list.get(list.size() - 1)).getCallType());
            if (list.size() > 2) {
                this.buildChildResponseMethodTime(list.subList(1, list.size() - 1), responseMethodTimeDto);
            }
            responseMethodTimeDtos.add(responseMethodTimeDto);
        }
        return responseMethodTimeDtos;
    }

    private void buildChildResponseMethodTime(List<MethodTimeDto> methodTimeDtos, ResponseMethodTimeDto responseMethodTimeDto) {
        Method firstMethod = null;
        int firstIndex = 0;
        for (int i = 0; i < methodTimeDtos.size(); ++i) {
            MethodTimeDto methodTimeDto = methodTimeDtos.get(i);
            if (firstMethod == null) {
                firstIndex = i;
                firstMethod = methodTimeDto.getMethod();
                continue;
            }
            if (!firstMethod.equals(methodTimeDto.getMethod())) continue;
            firstMethod = null;
            ResponseMethodTimeDto responseMethodTimeChildDto = new ResponseMethodTimeDto();
            responseMethodTimeChildDto.setClassName(methodTimeDtos.get(firstIndex).getClassZ().getCanonicalName());
            responseMethodTimeChildDto.setMethodName(methodTimeDtos.get(firstIndex).getMethod().getName());
            responseMethodTimeChildDto.setRequestTime(new Date(methodTimeDtos.get(firstIndex).getTimestamp()));
            responseMethodTimeChildDto.setTime(methodTimeDtos.get(i).getTimestamp() - methodTimeDtos.get(firstIndex).getTimestamp());
            responseMethodTimeChildDto.setLevelType(methodTimeDtos.get(firstIndex).getLevel());
            responseMethodTimeChildDto.setType(methodTimeDtos.get(i).getCallType());
            if (methodTimeDtos.size() > 2) {
                this.buildChildResponseMethodTime(methodTimeDtos.subList(firstIndex + 1, i), responseMethodTimeChildDto);
            }
            responseMethodTimeDto.getChildren().add(responseMethodTimeChildDto);
        }
    }

    @GetMapping(value={"/topFiveTimes"})
    public List<ResponseTimeDto> topFiveTimes() {
        Map<String, ResponseTimeDto> responseTimeDtoMap = this.localMeterRegistry.getTimeMap();
        ArrayList<ResponseTimeDto> result = new ArrayList<ResponseTimeDto>(responseTimeDtoMap.values());
        result.sort((o1, o2) -> Double.compare(o2.getTime().longValue(), o1.getTime().longValue()));
        return result.subList(0, Math.min(result.size(), 5));
    }

    @GetMapping(value={"/times"})
    public ResponseTimeDto times() {
        Map<String, ResponseTimeDto> responseTimeDtoMap = this.localMeterRegistry.getTimeMap();
        ResponseTimeDto result = new ResponseTimeDto();
        for (ResponseTimeDto value : responseTimeDtoMap.values()) {
            result.getLessTwoHundred().addAndGet(value.getLessTwoHundred().get());
            result.getLessFiveHundred().addAndGet(value.getLessFiveHundred().get());
            result.getLessOneThousand().addAndGet(value.getLessOneThousand().get());
            result.getGreaterOneThousand().addAndGet(value.getGreaterOneThousand().get());
            result.getAll().addAndGet(value.getAll().get());
        }
        return result;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"/method/{className:.*}"})
    @ResponseBody
    public Object methodClassName(@PathVariable String className) {
        MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(className);
        if (monitorMethodTimeDto == null) {
            return new ArrayList();
        }
        ArrayList<ResponseMethodTimeDto> responseMethodTimeDtos = new ArrayList<ResponseMethodTimeDto>();
        ArrayList<List<MethodTimeDto>> all = new ArrayList<List<MethodTimeDto>>(monitorMethodTimeDto.getQueue().getAll());
        for (List list : all) {
            ResponseMethodTimeDto responseMethodTimeDto = new ResponseMethodTimeDto();
            responseMethodTimeDto.setClassName(((MethodTimeDto)list.get(0)).getClassZ().getCanonicalName());
            responseMethodTimeDto.setMethodName(((MethodTimeDto)list.get(0)).getMethod().getName());
            responseMethodTimeDto.setLevelType(((MethodTimeDto)list.get(0)).getLevel());
            responseMethodTimeDto.setRequestTime(new Date(((MethodTimeDto)list.get(0)).getTimestamp()));
            responseMethodTimeDto.setTime(((MethodTimeDto)list.get(list.size() - 1)).getTimestamp() - ((MethodTimeDto)list.get(0)).getTimestamp());
            responseMethodTimeDto.setType(((MethodTimeDto)list.get(list.size() - 1)).getCallType());
            if (list.size() > 2) {
                this.buildChildResponseMethodTime(list.subList(1, list.size() - 1), responseMethodTimeDto);
            }
            responseMethodTimeDtos.add(responseMethodTimeDto);
        }
        return responseMethodTimeDtos;
    }

    @GetMapping(value={"/status"})
    public Map<String, Long> status() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Map.Entry<String, ResponseStatusDto> statusDtoEntry : this.localMeterRegistry.getStatusMap().entrySet()) {
            ResponseStatusDto statusDto = statusDtoEntry.getValue();
            for (int i = 1; i < 6; ++i) {
                String key = i + "xx";
                Long count = (Long)map.get(key);
                if (count == null) {
                    map.put(key, ((AtomicLong)Objects.requireNonNull(FieldUtils.getFieldValue("s" + i, statusDto))).longValue());
                    continue;
                }
                map.put(key, count + ((AtomicLong)Objects.requireNonNull(FieldUtils.getFieldValue("s" + i, statusDto))).longValue());
            }
        }
        return map;
    }

    @GetMapping(value={"/topFiveStatus"})
    public List<ResponseStatusDto> topFiveStatus() {
        ArrayList<ResponseStatusDto> responseStatusDtos = new ArrayList<ResponseStatusDto>(this.localMeterRegistry.getStatusMap().values());
        responseStatusDtos.sort((o1, o2) -> (int)(o2.getAll().get() - o1.getAll().get()));
        return responseStatusDtos.size() > 5 ? responseStatusDtos.subList(0, 5) : responseStatusDtos;
    }

    @GetMapping(value={"/responseList"})
    public List<Map<String, Object>> responseList() {
        Map<String, ResponseTimeDto> responseTimeDtoMap = this.localMeterRegistry.getTimeMap();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayList<ResponseStatusDto> responseStatusDtos = new ArrayList<ResponseStatusDto>(this.localMeterRegistry.getStatusMap().values());
        for (ResponseTimeDto responseTimeDto : responseTimeDtoMap.values()) {
            for (ResponseStatusDto responseStatusDto : responseStatusDtos) {
                if (!responseTimeDto.getUri().equals(responseStatusDto.getUri())) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(0);
                result.add(map);
                map.put("uri", responseTimeDto.getUri());
                map.put("responseStatusDto", responseStatusDto);
                map.put("responseTimeDto", responseTimeDto);
            }
        }
        return result;
    }

    @GetMapping(value={"/methods"})
    public Object methods(@RequestParam String searchValue) {
        if (!this.isInit) {
            this.init();
        }
        TreeMap<String, Map> mapMap = new TreeMap<String, Map>();
        for (String method : ConstantUtils.MONITOR_CLASSS) {
            if (!StringUtils.isEmpty((Object)searchValue) && !method.contains(searchValue.trim())) continue;
            int index = method.lastIndexOf(".");
            String className = method.substring(0, index);
            String methodName = method.substring(index + 1);
            Map map = mapMap.computeIfAbsent(className, k -> new TreeMap());
            map.put(methodName, false);
            MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(method);
            if (monitorMethodTimeDto == null) continue;
            map.put(methodName, true);
        }
        return mapMap;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"/method/classNames"})
    public Object methodClassName(@RequestBody List<String> classNames, @RequestParam(required=false) String classMethod) {
        if (!StringUtils.isEmpty((Object)classMethod)) {
            LOGIN_CACHE_MAP.remove(classMethod);
        }
        if (!CollectionUtils.isEmpty(classNames)) {
            for (String className : classNames) {
                MonitorMethodTimeDto monitorMethodTimeDto = LOGIN_CACHE_MAP.get(className);
                if (monitorMethodTimeDto != null) continue;
                monitorMethodTimeDto = new MonitorMethodTimeDto();
                monitorMethodTimeDto.setFullClassName(className);
                monitorMethodTimeDto.setLastTime(new Date());
                LOGIN_CACHE_MAP.put(className, monitorMethodTimeDto);
            }
        }
        return "ok";
    }

    @GetMapping(value={"/methodTimes"})
    public List<MethodMonitorTimeDto> methodTimes(@RequestParam String searchValue, @RequestParam DynamicAdvice.LevelType selectValue) {
        ArrayList<MethodMonitorTimeDto> methodMonitorTimeDtos = new ArrayList<MethodMonitorTimeDto>();
        for (Map.Entry<String, MethodMonitorTimeDto> stringMethodMonitorTimeDtoEntry : ConstantUtils.METHOD_MONITOR_CLASSS.entrySet()) {
            boolean isOk = !(selectValue != null && !stringMethodMonitorTimeDtoEntry.getValue().getLevelType().equals((Object)selectValue) || searchValue != null && !stringMethodMonitorTimeDtoEntry.getKey().contains(searchValue));
            if (!isOk) continue;
            methodMonitorTimeDtos.add(stringMethodMonitorTimeDtoEntry.getValue());
        }
        return methodMonitorTimeDtos;
    }

    public MonitorMethodTimeDto getMonitorMethodTimeDto(String classFullName) {
        return LOGIN_CACHE_MAP.get(classFullName);
    }

    static {
        executorService.scheduleAtFixedRate(() -> {
            HashSet<String> expiredKeys = new HashSet<String>();
            for (Map.Entry<String, MonitorMethodTimeDto> stringActuatorUserDtoEntry : LOGIN_CACHE_MAP.entrySet()) {
                if (!stringActuatorUserDtoEntry.getValue().getLastTime().before(DateUtils.addSeconds((Date)new Date(), (int)(-EXPIRE.intValue())))) continue;
                expiredKeys.add(stringActuatorUserDtoEntry.getKey());
            }
            for (String expiredKey : expiredKeys) {
                LOGIN_CACHE_MAP.remove(expiredKey);
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }
}

