/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.endpoint;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.luohuasheng.bee.rest.admin.client.aop.DynamicAdvice;
import net.luohuasheng.bee.rest.admin.client.dto.api.ApiCount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
@RestControllerEndpoint(id="api")
public class ApiEndPoint {
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private DynamicAdvice dynamicAdvice;

    @GetMapping(value={"/"})
    public List<ApiCount> api() {
        ArrayList<ApiCount> apis = new ArrayList<ApiCount>();
        for (Map.Entry requestMappingInfoHandlerMethodEntry : this.requestMappingHandlerMapping.getHandlerMethods().entrySet()) {
            HashSet<String> urls = new HashSet<String>();
            for (String pattern : ((RequestMappingInfo)requestMappingInfoHandlerMethodEntry.getKey()).getPatternsCondition().getPatterns()) {
                for (RequestMethod method : ((RequestMappingInfo)requestMappingInfoHandlerMethodEntry.getKey()).getMethodsCondition().getMethods()) {
                    urls.add(pattern + "_" + method.name());
                }
            }
            Method method = ((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getMethod();
            ApiCount apiCount = this.dynamicAdvice.getApiCount(method);
            if (apiCount == null) continue;
            apiCount.setRestApi(String.join((CharSequence)",", urls));
            apis.add(apiCount);
        }
        return apis;
    }
}

