/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.SimpleInfoContributor;

public class VersionDto {
    private static final VersionDto INSTANCE = VersionDto.load();
    private static final List<InfoContributor> INFO_CONTRIBUTORS = VersionDto.loadInfoEndpoints();
    private String buildGroupId;
    private String buildArtifactId;
    private String buildOsName;
    private String buildTime;
    private String buildName;
    private String buildEnvironment;
    private String buildVersion;
    private String springBootVersion;

    public static VersionDto getInstance() {
        return INSTANCE;
    }

    public static List<InfoContributor> getInfoContributors() {
        return INFO_CONTRIBUTORS;
    }

    private static VersionDto load() {
        VersionDto version = new VersionDto();
        Properties properties = VersionDto.loadProperties();
        version.setBuildTime(properties.getProperty("git.build.time"));
        version.setBuildEnvironment(properties.getProperty("Build-Jdk"));
        version.setBuildName(properties.getProperty("git.build.user.name"));
        version.setBuildVersion(properties.getProperty("git.build.version"));
        version.setBuildGroupId(properties.getProperty("groupId"));
        version.setBuildArtifactId(properties.getProperty("artifactId"));
        version.setSpringBootVersion(properties.getProperty("Spring-Boot-Version"));
        version.setBuildOsName(properties.getProperty("buildOsName"));
        return version;
    }

    private static List<InfoContributor> loadInfoEndpoints() {
        Properties properties = VersionDto.loadProperties();
        ArrayList<InfoContributor> infoEndpoints = new ArrayList<InfoContributor>();
        for (Object key : properties.keySet()) {
            String value = properties.getProperty((String)key);
            infoEndpoints.add((InfoContributor)new SimpleInfoContributor((String)key, (Object)value));
        }
        return infoEndpoints;
    }

    private static Properties loadProperties() {
        Properties properties = new Properties();
        try {
            Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            VersionDto.loadValue(en, properties);
            en = Thread.currentThread().getContextClassLoader().getResources("git.properties");
            VersionDto.loadValue(en, properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static void loadValue(Enumeration<URL> en, Properties properties) throws IOException {
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            if (url.getPath().contains("BOOT-INF/lib") || !url.getPath().contains(Objects.requireNonNull(VersionDto.class.getClassLoader().getResource("")).getFile().split("!")[0])) continue;
            InputStream is = url.openStream();
            properties.load(is);
        }
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getBuildEnvironment() {
        return this.buildEnvironment;
    }

    public void setBuildEnvironment(String buildEnvironment) {
        this.buildEnvironment = buildEnvironment;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public void setBuildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    public String getBuildGroupId() {
        return this.buildGroupId;
    }

    public void setBuildGroupId(String buildGroupId) {
        this.buildGroupId = buildGroupId;
    }

    public String getBuildArtifactId() {
        return this.buildArtifactId;
    }

    public void setBuildArtifactId(String buildArtifactId) {
        this.buildArtifactId = buildArtifactId;
    }

    public String getSpringBootVersion() {
        return this.springBootVersion;
    }

    public void setSpringBootVersion(String springBootVersion) {
        this.springBootVersion = springBootVersion;
    }

    public String getBuildOsName() {
        return this.buildOsName;
    }

    public void setBuildOsName(String buildOsName) {
        this.buildOsName = buildOsName;
    }
}

