/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class ProcessDto {
    private static Map<Integer, ProcessDto> processeMap = new HashMap<Integer, ProcessDto>();
    private String name;
    private Integer pid;
    private Integer parentPid;
    private String user;
    private String group;
    private OSProcess.State state;
    private Integer threadCount;
    private Long virtualSize;
    private Long residentSetSize;
    private Double memPercent;
    private Double cpuPercent;
    private Long startTime;
    private Long currentTime;
    private Long bytesRead;
    private Long bytesWritten;
    private Long openFiles;
    private String path;
    private String commandLine;
    private String currentWorkingDirectory;
    private Long readSpeed = 0L;
    private Long writeSpeed = 0L;
    private static final String PROCESSE_STORE_POOL_KEY = "processe-schedule-pool-%d";

    private static List<ProcessDto> loadProcesseDtos() {
        ArrayList<ProcessDto> processDtos = new ArrayList<ProcessDto>();
        long totalMemory = SystemInfoUtils.getMemory().getTotal();
        for (OSProcess process : SystemInfoUtils.getProcesses()) {
            ProcessDto processDto = new ProcessDto();
            processDto.commandLine = process.getCommandLine();
            processDto.currentWorkingDirectory = process.getCurrentWorkingDirectory();
            processDto.parentPid = process.getParentProcessID();
            processDto.pid = process.getProcessID();
            processDto.threadCount = process.getThreadCount();
            processDto.bytesRead = process.getBytesRead();
            processDto.bytesWritten = process.getBytesWritten();
            processDto.user = process.getUser();
            processDto.group = process.getGroup();
            processDto.state = process.getState();
            processDto.virtualSize = process.getVirtualSize();
            processDto.residentSetSize = process.getResidentSetSize();
            processDto.startTime = process.getStartTime();
            processDto.openFiles = process.getOpenFiles();
            processDto.name = process.getName();
            processDto.memPercent = 1.0 * (double)process.getResidentSetSize() / (double)totalMemory;
            processDto.currentTime = process.getKernelTime() + process.getUserTime();
            processDto.path = process.getPath();
            processDtos.add(processDto);
        }
        return processDtos;
    }

    public static ProcessDto getProcesseDto(String pid) {
        return processeMap.get(Integer.parseInt(pid));
    }

    private static Comparator<ProcessDto> loadComparator(OperatingSystem.ProcessSort processSort) {
        return (o1, o2) -> {
            switch (processSort) {
                case CPU: {
                    if (o1.cpuPercent == null || o2.cpuPercent == null) {
                        return 0;
                    }
                    return o2.cpuPercent.compareTo(o1.cpuPercent);
                }
                case PID: {
                    return o2.pid.compareTo(o1.pid);
                }
                case NAME: {
                    return o2.name.compareTo(o1.name);
                }
                case MEMORY: {
                    return o2.residentSetSize.compareTo(o1.residentSetSize);
                }
                case NEWEST: {
                    return o1.startTime.compareTo(o2.startTime);
                }
                case OLDEST: {
                    return o2.startTime.compareTo(o1.startTime);
                }
                case PARENTPID: {
                    return o2.parentPid.compareTo(o1.parentPid);
                }
            }
            return o2.memPercent.compareTo(o1.memPercent);
        };
    }

    public static List<ProcessDto> createProcesseDto(OperatingSystem.ProcessSort processSort) {
        ArrayList<ProcessDto> processDtos = new ArrayList<ProcessDto>();
        for (Map.Entry<Integer, ProcessDto> stringDiskStoreDtoEntry : processeMap.entrySet()) {
            processDtos.add(stringDiskStoreDtoEntry.getValue());
        }
        processDtos.sort(ProcessDto.loadComparator(processSort));
        return processDtos;
    }

    public static List<ProcessDto> createProcesseDto(OperatingSystem.ProcessSort processSort, Integer limit) {
        List<ProcessDto> processDtos = ProcessDto.createProcesseDto(processSort);
        ArrayList<ProcessDto> processDtos2 = new ArrayList<ProcessDto>();
        Integer i = 0;
        while (i < limit && i < processDtos.size()) {
            processDtos2.add(processDtos.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return processDtos2;
    }

    public Integer getPid() {
        return this.pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public Integer getParentPid() {
        return this.parentPid;
    }

    public void setParentPid(Integer parentPid) {
        this.parentPid = parentPid;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Integer getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public Long getVirtualSize() {
        return this.virtualSize;
    }

    public void setVirtualSize(Long virtualSize) {
        this.virtualSize = virtualSize;
    }

    public Long getResidentSetSize() {
        return this.residentSetSize;
    }

    public void setResidentSetSize(Long residentSetSize) {
        this.residentSetSize = residentSetSize;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(Long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public Long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(Long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public Long getOpenFiles() {
        return this.openFiles;
    }

    public void setOpenFiles(Long openFiles) {
        this.openFiles = openFiles;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public String getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory;
    }

    public void setCurrentWorkingDirectory(String currentWorkingDirectory) {
        this.currentWorkingDirectory = currentWorkingDirectory;
    }

    public OSProcess.State getState() {
        return this.state;
    }

    public void setState(OSProcess.State state) {
        this.state = state;
    }

    public Double getCpuPercent() {
        return this.cpuPercent;
    }

    public void setCpuPercent(Double cpuPercent) {
        this.cpuPercent = cpuPercent;
    }

    public Long getReadSpeed() {
        return this.readSpeed;
    }

    public void setReadSpeed(Long readSpeed) {
        this.readSpeed = readSpeed;
    }

    public Long getWriteSpeed() {
        return this.writeSpeed;
    }

    public void setWriteSpeed(Long writeSpeed) {
        this.writeSpeed = writeSpeed;
    }

    public Double getMemPercent() {
        return this.memPercent;
    }

    public void setMemPercent(Double memPercent) {
        this.memPercent = memPercent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Long currentTime) {
        this.currentTime = currentTime;
    }

    static {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(PROCESSE_STORE_POOL_KEY).daemon(true).build());
        executorService.scheduleAtFixedRate(() -> {
            HashMap<Integer, ProcessDto> processeMapTmp = new HashMap<Integer, ProcessDto>();
            List<ProcessDto> processDtos = ProcessDto.loadProcesseDtos();
            for (ProcessDto processDto : processDtos) {
                ProcessDto processDto1 = processeMap.get(processDto.pid);
                processeMapTmp.put(processDto.pid, processDto);
                if (processDto1 == null) continue;
                processDto.readSpeed = processDto.bytesRead - processDto1.bytesRead;
                processDto.writeSpeed = processDto.bytesWritten - processDto1.bytesWritten;
                processDto.cpuPercent = (double)(processDto.currentTime - processDto1.currentTime) / 1000.0 / (double)SystemInfoUtils.getProcessor().getLogicalProcessorCount();
            }
            processeMap = processeMapTmp;
        }, 0L, 1L, TimeUnit.SECONDS);
    }
}

