/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import oshi.hardware.HWDiskStore;

public class DiskStoreDto {
    private static Map<String, DiskStoreDto> diskStoreMap = new HashMap<String, DiskStoreDto>();
    private static final String DISK_STORE_POOL_KEY = "diskStore-schedule-pool-%d";
    private String name;
    private String model;
    private Long size;
    private Long reads;
    private Long readBytes;
    private Long writes;
    private Long writeBytes;
    private Long readSpeed = 0L;
    private Long writeSpeed = 0L;
    private Long readbSpeed = 0L;
    private Long writebSpeed = 0L;

    private static List<DiskStoreDto> loadDiskStoreDto() {
        ArrayList<DiskStoreDto> diskDtos = new ArrayList<DiskStoreDto>();
        for (HWDiskStore diskStore : SystemInfoUtils.getDiskStores()) {
            if (diskStore.getReadBytes() <= 0L) continue;
            DiskStoreDto diskStoreDto = new DiskStoreDto();
            diskStoreDto.name = diskStore.getName();
            diskStoreDto.size = diskStore.getSize();
            diskStoreDto.model = diskStore.getModel();
            diskStoreDto.reads = diskStore.getReads();
            diskStoreDto.readBytes = diskStore.getReadBytes();
            diskStoreDto.writes = diskStore.getWrites();
            diskStoreDto.writeBytes = diskStore.getWriteBytes();
            diskDtos.add(diskStoreDto);
        }
        return diskDtos;
    }

    public static List<DiskStoreDto> createDiskStores() {
        ArrayList<DiskStoreDto> diskDtos = new ArrayList<DiskStoreDto>();
        for (Map.Entry<String, DiskStoreDto> stringDiskStoreDtoEntry : diskStoreMap.entrySet()) {
            diskDtos.add(stringDiskStoreDtoEntry.getValue());
        }
        return diskDtos;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getReads() {
        return this.reads;
    }

    public void setReads(Long reads) {
        this.reads = reads;
    }

    public Long getReadBytes() {
        return this.readBytes;
    }

    public void setReadBytes(Long readBytes) {
        this.readBytes = readBytes;
    }

    public Long getWrites() {
        return this.writes;
    }

    public void setWrites(Long writes) {
        this.writes = writes;
    }

    public Long getWriteBytes() {
        return this.writeBytes;
    }

    public void setWriteBytes(Long writeBytes) {
        this.writeBytes = writeBytes;
    }

    public Long getReadSpeed() {
        return this.readSpeed;
    }

    public void setReadSpeed(Long readSpeed) {
        this.readSpeed = readSpeed;
    }

    public Long getWriteSpeed() {
        return this.writeSpeed;
    }

    public void setWriteSpeed(Long writeSpeed) {
        this.writeSpeed = writeSpeed;
    }

    public Long getReadbSpeed() {
        return this.readbSpeed;
    }

    public void setReadbSpeed(Long readbSpeed) {
        this.readbSpeed = readbSpeed;
    }

    public Long getWritebSpeed() {
        return this.writebSpeed;
    }

    public void setWritebSpeed(Long writebSpeed) {
        this.writebSpeed = writebSpeed;
    }

    static {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(DISK_STORE_POOL_KEY).daemon(true).build());
        executorService.scheduleAtFixedRate(() -> {
            HashMap<String, DiskStoreDto> diskStoreMapTmp = new HashMap<String, DiskStoreDto>();
            List<DiskStoreDto> diskDtos = DiskStoreDto.loadDiskStoreDto();
            for (DiskStoreDto diskDto : diskDtos) {
                DiskStoreDto diskDto2 = diskStoreMap.get(diskDto.name);
                diskStoreMapTmp.put(diskDto.name, diskDto);
                if (diskDto2 == null) continue;
                diskDto.readbSpeed = diskDto.reads - diskDto2.reads;
                diskDto.readSpeed = diskDto.readBytes - diskDto2.readBytes;
                diskDto.writeSpeed = diskDto.writes - diskDto2.writes;
                diskDto.writebSpeed = diskDto.writeBytes - diskDto2.writeBytes;
            }
            diskStoreMap = diskStoreMapTmp;
        }, 0L, 1L, TimeUnit.SECONDS);
    }
}

