/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import oshi.hardware.ComputerSystem;
import oshi.software.os.OperatingSystem;

public class ComputerSystemDto {
    private String model;
    private String serialNumber;
    private String manufacturer;
    private String operatingSystemName;
    private int processId;
    private int processCount;
    private int threadCount;
    private int bitness;
    private String hostName;
    private String domainName;
    private Long openFileDescriptors;
    private Long maxFileDescriptors;

    public ComputerSystemDto() {
        ComputerSystem computerSystem = SystemInfoUtils.getComputerSystem();
        this.model = computerSystem.getModel();
        this.serialNumber = computerSystem.getSerialNumber();
        this.manufacturer = computerSystem.getManufacturer();
        OperatingSystem operatingSystem = SystemInfoUtils.getOperatingSystem();
        this.operatingSystemName = operatingSystem.getManufacturer() + " " + operatingSystem.getFamily() + " " + operatingSystem.getVersionInfo().getVersion();
        this.processId = operatingSystem.getProcessId();
        this.processCount = operatingSystem.getProcessCount();
        this.threadCount = operatingSystem.getThreadCount();
        this.bitness = operatingSystem.getBitness();
        this.hostName = operatingSystem.getNetworkParams().getHostName();
        this.domainName = operatingSystem.getNetworkParams().getDomainName();
        this.openFileDescriptors = operatingSystem.getFileSystem().getOpenFileDescriptors();
        this.maxFileDescriptors = operatingSystem.getFileSystem().getMaxFileDescriptors();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getOperatingSystemName() {
        return this.operatingSystemName;
    }

    public void setOperatingSystemName(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public int getProcessCount() {
        return this.processCount;
    }

    public void setProcessCount(int processCount) {
        this.processCount = processCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getBitness() {
        return this.bitness;
    }

    public void setBitness(int bitness) {
        this.bitness = bitness;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Long getOpenFileDescriptors() {
        return this.openFileDescriptors;
    }

    public void setOpenFileDescriptors(Long openFileDescriptors) {
        this.openFileDescriptors = openFileDescriptors;
    }

    public Long getMaxFileDescriptors() {
        return this.maxFileDescriptors;
    }

    public void setMaxFileDescriptors(Long maxFileDescriptors) {
        this.maxFileDescriptors = maxFileDescriptors;
    }
}

