/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.components;

import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.LocalMeterRegistry;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import net.luohuasheng.bee.jdbc.tools.common.utils.StructureUtils;
import net.luohuasheng.bee.jdbc.tools.component.structure.dto.TableDto;
import net.luohuasheng.bee.proxy.core.utils.thread.DefaultThreadFactory;
import net.luohuasheng.bee.rest.admin.client.components.BasicComponent;
import net.luohuasheng.bee.rest.admin.client.dto.db.DbInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnClass(value={DataSource.class})
public class DataSourceComponent
implements BasicComponent {
    private ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(20, (ThreadFactory)new DefaultThreadFactory("column-pool-%d"));
    private Map<String, HikariDataSource> dataSourceMap = new HashMap<String, HikariDataSource>();
    private Map<String, DbInfo> dbinfo = new HashMap<String, DbInfo>();
    @Autowired
    private LocalMeterRegistry clientMeterRegistry;
    @Autowired
    private List<DataSource> dataSources;

    @PostConstruct
    private void init() {
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public List<List<TableDto>> getTables() throws SQLException, ExecutionException, InterruptedException {
        ArrayList<List<TableDto>> tables = new ArrayList<List<TableDto>>();
        if (!CollectionUtils.isEmpty(this.dataSources)) {
            for (DataSource dataSource : this.dataSources) {
                List list = StructureUtils.loadTables((DataSource)dataSource, (String)"table", (boolean)true);
                tables.add(list);
            }
        }
        return tables;
    }
}

