/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.proxy.rest.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.luohuasheng.bee.proxy.rest.annotation.Downloader;
import net.luohuasheng.bee.proxy.rest.annotation.Value;
import net.luohuasheng.bee.proxy.rest.convent.DownloadProcessor;
import net.luohuasheng.bee.proxy.rest.convent.MessageResult;
import net.luohuasheng.bee.proxy.rest.dto.RequestDto;
import net.luohuasheng.bee.proxy.rest.exception.ProxyException;
import net.luohuasheng.bee.proxy.rest.multipart.MultipartFileResource;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

public class RestUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Object callRest(RestTemplate restTemplate, RequestDto requestDto) {
        HttpEntity requestEntity = null;
        ResponseEntity responseEntity = null;
        switch (requestDto.getRequestMethod()) {
            case GET: {
                requestEntity = new HttpEntity(null, (MultiValueMap)requestDto.getHttpHeaders());
                break;
            }
            case PUT: {
                requestEntity = RestUtils.buildPutEntity(requestDto);
                break;
            }
            case POST: {
                requestEntity = RestUtils.buildPostEntity(requestDto);
                break;
            }
            case DELETE: {
                requestEntity = new HttpEntity(null, (MultiValueMap)requestDto.getHttpHeaders());
                break;
            }
        }
        try {
            if (requestDto.getMethod().getAnnotation(Downloader.class) != null) {
                HttpServletResponse response = null;
                for (Object arg : requestDto.getArgs() != null ? requestDto.getArgs() : new Object[]{}) {
                    if (!(arg instanceof HttpServletResponse)) continue;
                    response = (HttpServletResponse)arg;
                }
                if (response == null) {
                    responseEntity = restTemplate.exchange(requestDto.getUri(), HttpMethod.valueOf((String)requestDto.getRequestMethod().name()), requestEntity, InputStream.class, requestDto.getUriVariables());
                } else {
                    HttpServletResponse finalResponse = response;
                    responseEntity = (ResponseEntity)restTemplate.execute(requestDto.getUri(), HttpMethod.valueOf((String)requestDto.getRequestMethod().name()), null, clientHttpResponse -> {
                        if (!DownloadProcessor.load(clientHttpResponse.getBody(), clientHttpResponse.getHeaders())) {
                            for (String key : clientHttpResponse.getHeaders().keySet()) {
                                for (String value : clientHttpResponse.getHeaders().get((Object)key)) {
                                    finalResponse.addHeader(key, value);
                                }
                            }
                            StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)finalResponse.getOutputStream());
                        }
                        return null;
                    }, requestDto.getUriVariables());
                }
            } else {
                responseEntity = restTemplate.exchange(requestDto.getUri(), HttpMethod.valueOf((String)requestDto.getRequestMethod().name()), requestEntity, requestDto.getTypeReference(), requestDto.getUriVariables());
            }
        }
        catch (HttpClientErrorException e) {
            ProxyException proxyException = new ProxyException();
            proxyException.setState(e.getStatusCode().value());
            try {
                Map map = (Map)OBJECT_MAPPER.readValue(e.getResponseBodyAsByteArray(), Map.class);
                proxyException.setCode(map.get("code").toString());
                proxyException.setMessage((String)map.get("message"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw proxyException;
        }
        return requestEntity == null || responseEntity == null ? null : RestUtils.loadValue(responseEntity.getBody());
    }

    private static Object loadValue(Object body) {
        if (body == null) {
            return null;
        }
        for (Method method : body.getClass().getMethods()) {
            if (method.getAnnotation(Value.class) == null) continue;
            try {
                return method.invoke(body, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return body;
            }
        }
        return body;
    }

    private static HttpEntity<?> buildPutEntity(RequestDto requestDto) {
        return RestUtils.buildPostEntity(requestDto);
    }

    private static HttpEntity<?> buildPostEntity(RequestDto requestDto) {
        if (requestDto.getBody() != null) {
            requestDto.getHttpHeaders().setContentType(MediaType.APPLICATION_JSON_UTF8);
            return new HttpEntity(requestDto.getBody(), (MultiValueMap)requestDto.getHttpHeaders());
        }
        if (requestDto.getFiles() != null) {
            requestDto.getHttpHeaders().setContentType(MediaType.MULTIPART_FORM_DATA);
            LinkedMultiValueMap param = new LinkedMultiValueMap();
            if (requestDto.getFiles().getClass().isArray()) {
                MultipartFile[] multipartFiles;
                for (MultipartFile multipartFile : multipartFiles = (MultipartFile[])requestDto.getFiles()) {
                    param.add((Object)requestDto.getFileName(), (Object)new MultipartFileResource(multipartFile));
                }
            } else {
                param.add((Object)requestDto.getFileName(), (Object)new MultipartFileResource((MultipartFile)requestDto.getFiles()));
            }
            return new HttpEntity((Object)param, (MultiValueMap)requestDto.getHttpHeaders());
        }
        return new HttpEntity(requestDto.getBody(), (MultiValueMap)requestDto.getHttpHeaders());
    }

    public static RequestDto getRequest(Method method, Object[] args, Class<MessageResult> messageResultClass) {
        RequestDto requestDto = new RequestDto();
        requestDto.setMethod(method);
        requestDto.setConventType(messageResultClass);
        requestDto.setArgs(args);
        requestDto.setResponseType(method.getReturnType());
        RestUtils.buildUri(method, requestDto);
        RestUtils.buildRequestParam(method, args, requestDto);
        return requestDto;
    }

    private static void buildRequestParam(Method method, Object[] args, RequestDto requestDto) {
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discover.getParameterNames(method);
        HashMap<String, Object> uriVariables = new HashMap<String, Object>(0);
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] classes = method.getParameterTypes();
        StringBuilder query = new StringBuilder("?");
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] annotation = annotations[i];
            Class<?> type = classes[i];
            for (Annotation annotation1 : annotation) {
                if (annotation1 instanceof RequestParam || annotation1 instanceof PathVariable) {
                    String paramName = null;
                    paramName = annotation1 instanceof RequestParam ? (ObjectUtils.isEmpty((Object)((RequestParam)annotation1).value()) ? parameterNames[i] : ((RequestParam)annotation1).value()) : (ObjectUtils.isEmpty((Object)((PathVariable)annotation1).value()) ? parameterNames[i] : ((PathVariable)annotation1).value());
                    if (args[i] == null) continue;
                    if (!MultipartFile.class.isAssignableFrom(type)) {
                        uriVariables.put(paramName, args[i]);
                        query.append("&").append(paramName).append("={").append(paramName).append("}");
                        continue;
                    }
                    requestDto.setFiles(args[i]);
                    requestDto.setFileName(paramName);
                    continue;
                }
                if (!(annotation1 instanceof RequestBody)) continue;
                requestDto.setBody(args[i]);
            }
        }
        JavaType javaType = null;
        if (method.getGenericReturnType() instanceof Class) {
            javaType = method.getGenericReturnType().equals(Void.TYPE) ? OBJECT_MAPPER.getTypeFactory().constructParametricType(requestDto.getConventType(), new Class[]{Long.TYPE}) : OBJECT_MAPPER.getTypeFactory().constructParametricType(requestDto.getConventType(), new Class[]{(Class)method.getGenericReturnType()});
        } else if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            Type[] types = parameterizedType.getActualTypeArguments();
            Class[] classs = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                Type type = types[i];
                classs[i] = (Class)type;
            }
            JavaType subType = OBJECT_MAPPER.getTypeFactory().constructParametricType((Class)parameterizedType.getRawType(), classs);
            javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(requestDto.getConventType(), new JavaType[]{subType});
        } else {
            javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(requestDto.getConventType(), new JavaType[]{(JavaType)method.getGenericReturnType()});
        }
        requestDto.setTypeReference(ParameterizedTypeReference.forType((Type)javaType));
        requestDto.setUri(uriVariables.isEmpty() ? requestDto.getUri() : requestDto.getUri() + query.toString());
        requestDto.setUriVariables(uriVariables);
    }

    private static void buildUri(Method method, RequestDto requestDto) {
        DeleteMapping deleteMapping;
        PostMapping postMapping;
        PutMapping putMapping;
        Class<?> registClass = method.getDeclaringClass();
        StringBuilder uri = new StringBuilder();
        RequestMapping requestMapping = registClass.getAnnotation(RequestMapping.class);
        if (requestMapping != null) {
            uri.append(requestMapping.value()[0]);
        }
        String url = null;
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (getMapping != null) {
            requestDto.setRequestMethod(RequestMethod.GET);
            url = getMapping.value()[0];
        }
        if ((putMapping = method.getAnnotation(PutMapping.class)) != null) {
            requestDto.setRequestMethod(RequestMethod.PUT);
            url = putMapping.value()[0];
        }
        if ((postMapping = method.getAnnotation(PostMapping.class)) != null) {
            requestDto.setRequestMethod(RequestMethod.POST);
            url = postMapping.value()[0];
        }
        if ((deleteMapping = method.getAnnotation(DeleteMapping.class)) != null) {
            requestDto.setRequestMethod(RequestMethod.DELETE);
            url = deleteMapping.value()[0];
        }
        if ((requestMapping = method.getAnnotation(RequestMapping.class)) != null) {
            requestDto.setRequestMethod(requestMapping.method()[0]);
            url = requestMapping.value()[0];
        }
        uri.append(url == null || url.startsWith("/") ? url : "/" + url);
        requestDto.setUri(uri.toString());
    }
}

