/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.proxy.rest.convent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.luohuasheng.bee.proxy.rest.dto.DownloadData;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StreamUtils;

public class DownloadProcessor {
    private static final ThreadLocal<DownloadData> DATA_THREAD_LOCAL = new ThreadLocal();

    public static void create() {
        DATA_THREAD_LOCAL.set(new DownloadData());
    }

    public static boolean load(InputStream inputStream, HttpHeaders header) {
        DownloadData downloadData = DATA_THREAD_LOCAL.get();
        if (downloadData != null) {
            downloadData.setHeader(header);
            try {
                downloadData.setInputStream(new ByteArrayInputStream(StreamUtils.copyToByteArray((InputStream)inputStream)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static DownloadData get() {
        try {
            DownloadData downloadData = DATA_THREAD_LOCAL.get();
            return downloadData;
        }
        finally {
            DATA_THREAD_LOCAL.remove();
        }
    }
}

