package net.luohuasheng.bee.proxy.rest.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.luohuasheng.bee.proxy.rest.annotation.Downloader;
import net.luohuasheng.bee.proxy.rest.annotation.DynamicResp;
import net.luohuasheng.bee.proxy.rest.annotation.Value;
import net.luohuasheng.bee.proxy.rest.convent.DownloadProcessor;
import net.luohuasheng.bee.proxy.rest.convent.MessageResult;
import net.luohuasheng.bee.proxy.rest.dto.DynamicBean;
import net.luohuasheng.bee.proxy.rest.dto.RequestDto;
import net.luohuasheng.bee.proxy.rest.exception.ProxyException;
import net.luohuasheng.bee.proxy.rest.multipart.MultipartFileResource;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wusm
 */
public class RestUtils {

    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Object callRest(RestTemplate restTemplate, RequestDto requestDto) {
        HttpEntity<?> requestEntity = null;
        ResponseEntity<?> responseEntity = null;
        switch (requestDto.getRequestMethod()) {
            case GET:
                requestEntity = new HttpEntity<String>(null, requestDto.getHttpHeaders());
                break;
            case PUT:
                requestEntity = buildPutEntity(requestDto);
                break;
            case POST:
                requestEntity = buildPostEntity(requestDto);

                break;
            case DELETE:
                requestEntity = new HttpEntity<String>(null, requestDto.getHttpHeaders());
                break;
            default:
                break;
        }
        try {
            if (requestDto.getMethod().getAnnotation(Downloader.class) != null) {
                HttpServletResponse response = null;
                for (Object arg : requestDto.getArgs() != null ? requestDto.getArgs() : new Object[0]) {
                    if (arg instanceof HttpServletResponse) {
                        response = (HttpServletResponse) arg;
                    }
                }
                if (response == null) {
                    responseEntity = restTemplate.exchange(requestDto.getUri(), HttpMethod.valueOf(requestDto.getRequestMethod().name()), requestEntity, InputStream.class, requestDto.getUriVariables());
                } else {
                    HttpServletResponse finalResponse = response;
                    responseEntity = restTemplate.execute(requestDto.getUri(), HttpMethod.valueOf(requestDto.getRequestMethod().name()), null, clientHttpResponse -> {
                        if (!DownloadProcessor.load(clientHttpResponse.getBody(), clientHttpResponse.getHeaders())) {
                            for (String key : clientHttpResponse.getHeaders().keySet()) {
                                for (String value : clientHttpResponse.getHeaders().get(key)) {
                                    finalResponse.addHeader(key, value);
                                }
                            }
                            StreamUtils.copy(clientHttpResponse.getBody(), finalResponse.getOutputStream());
                        }
                        return null;
                    }, requestDto.getUriVariables());
                }
            }
//            else if (requestDto.getMethod().getAnnotation(DynamicResp.class) != null) {
//
//                ResponseEntity<Map> mapEntity = restTemplate.exchange(requestDto.getUri(), HttpMethod.valueOf(requestDto.getRequestMethod().name()), requestEntity, Map.class, requestDto.getUriVariables());
//
//                if (requestDto.getResponseType().isAssignableFrom(List.class)) {
//                    List<?> dataList = (List<?>) mapEntity.getBody().get("data");
//                    responseEntity = new ResponseEntity<>(dataList, mapEntity.getStatusCode());
//
//                } else {
//                    Map<String, ?> dataMap = (Map<String, ?>) mapEntity.getBody().get("data");
//                    Map<String, Class<?>> typeMap = new HashMap<>(0);
//                    dataMap.forEach((key, value) -> {
//                        typeMap.put(key, value.getClass());
//                    });
//                    DynamicBean<?> dynamicVo = new DynamicBean<>(typeMap, requestDto.getResponseType());
//                    dataMap.forEach(dynamicVo::setValue);
//                    responseEntity = new ResponseEntity<>(dynamicVo.getObject(), mapEntity.getStatusCode());
//                }
//
//            }
            else {
                responseEntity = restTemplate.exchange(requestDto.getUri(), HttpMethod.valueOf(requestDto.getRequestMethod().name()), requestEntity, requestDto.getTypeReference(), requestDto.getUriVariables());
            }

        } catch (HttpClientErrorException e) {
            ProxyException proxyException = new ProxyException();
            proxyException.setState(e.getStatusCode().value());
            try {
                Map map = OBJECT_MAPPER.readValue(e.getResponseBodyAsByteArray(), Map.class);
                proxyException.setCode(map.get("code").toString());
                proxyException.setMessage((String) map.get("message"));
            } catch (IOException ex) {
                ex.printStackTrace();
            }
            throw proxyException;
        }


        return requestEntity == null || responseEntity == null ? null : loadValue(responseEntity.getBody());
    }

    private static Object loadValue(Object body) {
        if (body == null) {
            return null;
        } else {
            for (Method method : body.getClass().getMethods()) {
                if (method.getAnnotation(Value.class) != null) {
                    try {
                        return method.invoke(body);
                    } catch (IllegalAccessException | InvocationTargetException e) {
                        return body;
                    }
                }
            }
            return body;
        }
    }

    private static HttpEntity<?> buildPutEntity(RequestDto requestDto) {
        return buildPostEntity(requestDto);
    }

    private static HttpEntity<?> buildPostEntity(RequestDto requestDto) {
        if (requestDto.getBody() != null) {
            requestDto.getHttpHeaders().setContentType(MediaType.APPLICATION_JSON_UTF8);
            return new HttpEntity<>(requestDto.getBody(), requestDto.getHttpHeaders());
        } else if (requestDto.getFiles() != null) {
            requestDto.getHttpHeaders().setContentType(MediaType.MULTIPART_FORM_DATA);
            MultiValueMap<String, Object> param = new LinkedMultiValueMap<>();
            if (requestDto.getFiles().getClass().isArray()) {
                MultipartFile[] multipartFiles = (MultipartFile[]) requestDto.getFiles();
                for (MultipartFile multipartFile : multipartFiles) {
                    param.add(requestDto.getFileName(), new MultipartFileResource(multipartFile));
                }
            } else {
                param.add(requestDto.getFileName(), new MultipartFileResource(((MultipartFile) requestDto.getFiles())));
            }
            return new HttpEntity<>(param, requestDto.getHttpHeaders());

        } else {
            return new HttpEntity<>(requestDto.getBody(), requestDto.getHttpHeaders());
        }
    }


    /**
     * 获取请求对象
     *
     * @param method             请求方法
     * @param args               请求参数
     * @param messageResultClass 返回对象类型
     * @return 请求对象
     */
    public static RequestDto getRequest(Method method, Object[] args, Class<MessageResult> messageResultClass) {
        RequestDto requestDto = new RequestDto();
        requestDto.setMethod(method);
        requestDto.setConventType(messageResultClass);
        requestDto.setArgs(args);
        requestDto.setResponseType(method.getReturnType());
        buildUri(method, requestDto);
        buildRequestParam(method, args, requestDto);
        return requestDto;
    }

    private static void buildRequestParam(Method method, Object[] args, RequestDto requestDto) {
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discover.getParameterNames(method);
        Map<String, Object> uriVariables = new HashMap<>(0);
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] classes = method.getParameterTypes();
        StringBuilder query = new StringBuilder("?");
        for (int i = 0; i < annotations.length; i++) {
            Annotation[] annotation = annotations[i];
            Class<?> type = classes[i];
            for (Annotation annotation1 : annotation) {
                if (annotation1 instanceof RequestParam || annotation1 instanceof PathVariable) {
                    String paramName = null;
                    if (annotation1 instanceof RequestParam) {

                        if (ObjectUtils.isEmpty(((RequestParam) annotation1).value())) {
                            paramName = parameterNames[i];
                        } else {
                            paramName = ((RequestParam) annotation1).value();
                        }
                    } else {
                        if (ObjectUtils.isEmpty(((PathVariable) annotation1).value())) {
                            paramName = parameterNames[i];
                        } else {
                            paramName = ((PathVariable) annotation1).value();
                        }
                    }
                    if (args[i] != null) {
                        if (!MultipartFile.class.isAssignableFrom(type)) {
                            uriVariables.put(paramName, args[i]);
                            query.append("&").append(paramName).append("={").append(paramName).append("}");
                        } else {
                            requestDto.setFiles(args[i]);
                            requestDto.setFileName(paramName);
                        }
                    }
                } else if (annotation1 instanceof RequestBody) {
                    requestDto.setBody(args[i]);
                }

            }

        }
        JavaType javaType = null;
        if (method.getGenericReturnType() instanceof Class) {
            if (method.getGenericReturnType().equals(Void.TYPE)) {
                javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(requestDto.getConventType(), Long.TYPE);
            } else {
                javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(requestDto.getConventType(), (Class<?>) method.getGenericReturnType());

            }
        } else if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType) method.getGenericReturnType();
            Type[] types = parameterizedType.getActualTypeArguments();
            Class<?>[] classs = new Class[types.length];
            for (int i = 0; i < types.length; i++) {
                Type type = types[i];
                classs[i] = (Class<?>) type;
            }
            JavaType subType = OBJECT_MAPPER.getTypeFactory().constructParametricType((Class<?>) parameterizedType.getRawType(), classs);

            javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(requestDto.getConventType(), subType);
        } else {
            javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(requestDto.getConventType(), (JavaType) method.getGenericReturnType());

        }
        requestDto.setTypeReference(ParameterizedTypeReference.forType(javaType));
        requestDto.setUri(uriVariables.isEmpty() ? requestDto.getUri() : requestDto.getUri() + query.toString());
        requestDto.setUriVariables(uriVariables);
    }


    /**
     * 构建请求地址
     *
     * @param method     请求方法
     * @param requestDto 请求对象
     */
    private static void buildUri(Method method, RequestDto requestDto) {
        Class<?> registClass = method.getDeclaringClass();
        StringBuilder uri = new StringBuilder();
        //获取类请求路径
        RequestMapping requestMapping = registClass.getAnnotation(RequestMapping.class);
        if (requestMapping != null) {
            uri.append(requestMapping.value()[0]);
        }
        //获取方法请求路径
        {
            String url = null;
            GetMapping getMapping = method.getAnnotation(GetMapping.class);
            if (getMapping != null) {
                requestDto.setRequestMethod(RequestMethod.GET);
                url = getMapping.value()[0];
            }
            PutMapping putMapping = method.getAnnotation(PutMapping.class);
            if (putMapping != null) {
                requestDto.setRequestMethod(RequestMethod.PUT);
                url = putMapping.value()[0];
            }
            PostMapping postMapping = method.getAnnotation(PostMapping.class);
            if (postMapping != null) {
                requestDto.setRequestMethod(RequestMethod.POST);
                url = postMapping.value()[0];
            }
            DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
            if (deleteMapping != null) {
                requestDto.setRequestMethod(RequestMethod.DELETE);
                url = deleteMapping.value()[0];
            }
            requestMapping = method.getAnnotation(RequestMapping.class);
            if (requestMapping != null) {
                requestDto.setRequestMethod(requestMapping.method()[0]);
                url = requestMapping.value()[0];
            }
            uri.append((url == null || url.startsWith("/")) ? url : "/" + url);

            requestDto.setUri(uri.toString());
        }
    }
}
