package net.luohuasheng.bee.proxy.rest.dto;

import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Method;
import java.util.Map;

/**
 * @author wusuoming
 */
public class RequestDto {
    private String uri;
    private Class<?> responseType;
    private Class<?> conventType;

    private ParameterizedTypeReference<?> typeReference;
    private RequestMethod requestMethod;
    private Object body;
    private MultiValueMap<String, Object> valueMap = new LinkedMultiValueMap<>();
    private Object files;
    private String fileName;
    private Object[] args;
    private Method method;

    private Map<String, Object> uriVariables;
    private final HttpHeaders httpHeaders = new HttpHeaders();

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }


    public Map<String, Object> getUriVariables() {
        return uriVariables;
    }

    public void setUriVariables(Map<String, Object> uriVariables) {
        this.uriVariables = uriVariables;
    }

    public HttpHeaders getHttpHeaders() {
        return httpHeaders;
    }

    public void addHttpHeaders(String headerName, String headerValue) {
        this.httpHeaders.add(headerName, headerValue);
    }

    public Object getBody() {
        return body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public Class<?> getResponseType() {
        return responseType;
    }

    public void setResponseType(Class<?> responseType) {
        this.responseType = responseType;
    }

    public ParameterizedTypeReference<?> getTypeReference() {
        return typeReference;
    }

    public void setTypeReference(ParameterizedTypeReference<?> typeReference) {
        this.typeReference = typeReference;
    }

    public MultiValueMap<String, Object> getValueMap() {
        return valueMap;
    }

    public void setValueMap(MultiValueMap<String, Object> valueMap) {
        this.valueMap = valueMap;
    }

    public Object getFiles() {
        return files;
    }

    public void setFiles(Object files) {
        this.files = files;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Object[] getArgs() {
        return args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public RequestMethod getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Method getMethod() {
        return method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Class<?> getConventType() {
        return conventType;
    }

    public void setConventType(Class<?> conventType) {
        this.conventType = conventType;
    }
}
