package net.luohuasheng.bee.proxy.rest.dto;

import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.cglib.beans.BeanMap;

import java.util.Map;
import java.util.Set;

/**
 * @author wusuoming
 */
public class DynamicBean<T> {

    private Object object = null;

    private BeanMap beanMap = null;

    public DynamicBean() {
        super();
    }

    public DynamicBean(Map<String, Class<?>> propertyMap, Class<T> superClass) {
        this.object = generateBean(propertyMap, superClass);
        this.beanMap = BeanMap.create(this.object);
    }

    private Object generateBean(Map<String, Class<?>> propertyMap, Class<T> superClass) {
        BeanGenerator generator = new BeanGenerator();
        Set<String> keySet = propertyMap.keySet();
        for (String key : keySet) {
            generator.addProperty(key, propertyMap.get(key));
        }
        generator.setSuperclass(superClass);
        return generator.create();
    }


    public void setValue(Object property, Object value) {
        beanMap.put(property, value);
    }


    public Object getValue(String property) {
        return beanMap.get(property);
    }


    public Object getObject() {
        return this.object;
    }
}
